% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamlss-tidiers.R
\name{tidy.gamlss}
\alias{tidy.gamlss}
\title{Tidy a(n) gamlss object}
\usage{
\method{tidy}{gamlss}(x, quick = FALSE, ...)
}
\arguments{
\item{x}{A \code{gamlss} object returned from \code{\link[gamlss:gamlss]{gamlss::gamlss()}}.}

\item{quick}{Logical indiciating if the only the \code{term} and \code{estimate}
columns should be returned. Often useful to avoid time consuming
covariance and standard error calculations. Defaults to \code{FALSE}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row for each coefficient, containing columns
\item{parameter}{Type of coefficient being estimated: \code{mu}, \code{sigma},
\code{nu}, or \code{tau}.}
\item{term}{Name of term in the model.}
\item{estimate}{Estimate coefficient of given term.}
\item{std.error}{Standard error of given term.}
\item{statistic}{T-statistic used to test hypothesis that coefficien
equals zero.}
\item{p.value}{Two sided p-value based on null hypothesis of coefficient
equaling zero.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

library(gamlss)

g <- gamlss(
  y ~ pb(x),
  sigma.fo = ~ pb(x),
  family = BCT,
  data = abdom,
  method = mixed(1, 20)
)

tidy(g)

}
