% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryMA.R
\name{summaryMA}
\alias{summaryMA}
\title{Summary of model averaged linear mixed models}
\usage{
summaryMA(object, randeff = FALSE)
}
\arguments{
\item{object}{A object created by the model averaging function.}

\item{randeff}{logical. Indicator whether the model averaged random effects should also be part of the output. The default setting is FALSE.}
}
\value{
Outputs a summary of the model averaged random and fixed effects, as well as the calculated weights of the individual candidate models.
}
\description{
summaryMA is a function used to produce result summaries of the model 
averaging approach.
}
\examples{
data(Orthodont, package = "nlme")
models <- list(
    model1 <- lmer(formula = distance ~ age + Sex + (1 | Subject) + age:Sex,
               data = Orthodont),
    model2 <- lmer(formula = distance ~ age + Sex + (1 | Subject),
               data = Orthodont),
    model3 <- lmer(formula = distance ~ age + (1 | Subject),
                 data = Orthodont),
    model4 <- lmer(formula = distance ~ Sex + (1 | Subject),
                data = Orthodont))
foo <- modelAvg(models = models)
summaryMA(foo)


}
\references{
Greven, S. and Kneib T. (2010) On the behaviour of marginal and
conditional AIC in linear mixed models. Biometrika 97(4), 773-789.
}
\seealso{
\code{\link[lme4]{lme4-package}}, \code{\link[lme4]{lmer}}
}
\author{
Benjamin Saefken & Rene-Marcel Kruse
}
