% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-whole-numeric.R
\name{chk_whole_numeric}
\alias{chk_whole_numeric}
\alias{vld_whole_numeric}
\title{Check Whole Numeric}
\usage{
chk_whole_numeric(x, x_name = NULL)

vld_whole_numeric(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if integer vector or double equivalent using

\code{is.integer(x) || (is.double(x) && vld_true(all.equal(x, as.integer(x))))}
}
\section{Functions}{
\itemize{
\item \code{vld_whole_numeric()}: Validate Whole Numeric

}}
\examples{
# chk_whole_numeric
chk_whole_numeric(1)
try(chk_whole_numeric(1.1))
# vld_whole_numeric
vld_whole_numeric(1)
vld_whole_numeric(NA_real_)
vld_whole_numeric(1:2)
vld_whole_numeric(double(0))
vld_whole_numeric(TRUE)
vld_whole_numeric(1.5)
}
\seealso{
Other chk_is: 
\code{\link{chk_array}()},
\code{\link{chk_atomic}()},
\code{\link{chk_data}()},
\code{\link{chk_function}()},
\code{\link{chk_is}()},
\code{\link{chk_matrix}()},
\code{\link{chk_numeric}()},
\code{\link{chk_s3_class}()},
\code{\link{chk_s4_class}()},
\code{\link{chk_vector}()}
}
\concept{chk_is}
