% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{abort_chk}
\alias{abort_chk}
\title{Abort Check}
\usage{
abort_chk(..., n = NULL, tidy = TRUE, call = rlang::caller_call(2))
}
\arguments{
\item{...}{Multiple objects that are converted to a string using
\code{paste0(..., collapse = '')}.}

\item{n}{The value of n for converting \code{sprintf}-like types.}

\item{tidy}{A flag specifying whether capitalize the first character and add a missing period.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
Throws an error of class \code{'chk_error'}.
}
\description{
A wrapper on \code{\link[=err]{err()}} that sets the subclass to be \code{'chk_error'}.
}
\details{
It is exported to allow users to easily construct their own \code{chk_} functions.
}
\examples{
try(abort_chk("x must be NULL"))
try(abort_chk("`x` must be NULL"))
try(abort_chk("there \%r \%n problem value\%s", n = 1))
try(abort_chk("there \%r \%n problem value\%s", n = 1.5))
}
\seealso{
\code{\link[=err]{err()}}
}
