% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handle_conditions.R
\name{handle_conditions}
\alias{handle_conditions}
\alias{handle_messages}
\alias{handle_warnings}
\title{Handle conditions}
\usage{
handle_conditions(expr, condition = "message", times = 1)

handle_messages(expr, times = 1)

handle_warnings(expr, times = 1)
}
\arguments{
\item{expr}{an expression}

\item{condition}{(character) one of "message" or "warning"}

\item{times}{(integer) max. times a condition should be thrown.
default: 1}
}
\value{
whatever the \code{expr} returns
}
\description{
Handle conditions
}
\details{
Uses \link{ConditionKeeper} internally
}
\examples{
foo <- function(x) {
  message("you gave: ", x)
  return(x)
}

foo('a')
capture_message(foo('a'))
handle_conditions(foo('a'))
suppressMessages(handle_conditions(foo('a')))
handle_conditions(foo('a'), "message")

bar <- function(x) {
  for (i in x) message("you gave: ", i)
  return(x)
}
bar(1:5)
handle_conditions(bar(1:5))

handle_messages(foo('a'))

hello <- function(x) {
  warning("you gave: ", x)
  return(x)
}
handle_warnings(hello('a'))

# code block
handle_warnings({
  as.numeric(letters[1:3])
  as.numeric(letters[4:6])
  as.numeric(letters[7:9])
})
}
