% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf_crop.R
\name{pdf_crop}
\alias{pdf_crop}
\title{Remove whitespace margins from a PDF file}
\usage{
pdf_crop(filename, mustWork = FALSE, pdfcrop = Sys.which("pdfcrop"))
}
\arguments{
\item{filename}{Filename of a PDF file to crop. The file will be overwritten.}

\item{mustWork}{If \code{TRUE}, then give an error if the file cannot be cropped.}

\item{pdfcrop}{Path to the \code{pdfcrop} utility.}
}
\value{
Nothing
}
\description{
Remove whitespace margins using \url{https://ctan.org/pkg/pdfcrop}
}
\examples{
\dontrun{
extdata_path <- system.file(package = "eaf", "extdata")
A1 <- read_datasets(file.path(extdata_path, "wrots_l100w10_dat"))
A2 <- read_datasets(file.path(extdata_path, "wrots_l10w100_dat"))
pdf(file = "eaf.pdf", onefile = TRUE, width = 5, height = 4)
eafplot(list(A1 = A1, A2 = A2), percentiles = 50, sci.notation=TRUE)
dev.off()
pdf_crop("eaf.pdf")
}
}
