% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font-getters.R
\name{fonts}
\alias{font}
\alias{font_symbol}
\alias{fonts}
\title{Get elements of a fontset}
\usage{
fonts(fontset)

font(fontset, variant, style)

font_symbol(fontset = "Symbola")
}
\arguments{
\item{fontset}{A string giving the name of a set of fonts
(e.g. \code{"Liberation"} or\code{"Bitstream Vera"}). Use
\code{\link{fontset_list}()} to obtain the list of fontsets
registered in your session.}

\item{variant}{Font variant, as per Fontconfig's nomenclature. Use
\code{\link{fontset_variants}()} to find out which variants are
available for a fontset.}

\item{style}{Font style, as per Fontconfig's nomenclature. Use
\code{\link{fontset_styles}()} to find out which variants are
available for a fontset.}
}
\description{
\code{fonts()} returns the list of all \code{font} objects for a
given fontset (a collection of fonts provided by fontquiver, such
as \code{Liberation} or \code{Bitstream Vera}). \code{font()}
returns one specific font. \code{font_symbol()} extracts the font
marked as symbol font, if it exists in the fontset.
}
\examples{
font("Bitstream Vera", "Sans", "Roman")

f <- fonts("Liberation")
str(f, 1)

font_symbol("Symbola")
}

