% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regon.R
\name{geom_regon}
\alias{geom_regon}
\alias{stat_regon}
\title{Draw regular polygons by specifying number of sides}
\usage{
stat_regon(
  mapping = NULL,
  data = NULL,
  geom = "shape",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_regon(
  mapping = NULL,
  data = NULL,
  stat = "regon",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}
}
\description{
This geom makes it easy to construct regular polygons (polygons where all
sides and angles are equal) by specifying the number of sides, position, and
size. The polygons are always rotated so that they "rest" on a flat side, but
this can be changed with the angle aesthetic. The size is based on the radius
of their circumcircle and is thus not proportional to their area.
}
\section{Aesthetics}{

geom_regon understand the following aesthetics (required aesthetics are in
bold):
\itemize{
\item \strong{x0} x coordinate
\item \strong{y0} y coordinate
\item \strong{sides} the number of sides for regon
\item \strong{r} the ratio of regon with respect to plot
\item \strong{angle} regon rotation angle (unit is radian)
\item color
\item fill
\item size
\item linetype
\item alpha
\item lineend
}
}

\section{Computed variables}{


\describe{
\item{x, y}{The coordinates for the corners of the polygon}
}
}

\examples{
ggplot() +
  geom_regon(aes(x0 = runif(8), y0 = runif(8), sides = sample(3:10, 8),
                 angle = 0, r = runif(8) / 10)) +
  coord_fixed()

# The polygons are drawn with geom_shape, so can be manipulated as such
ggplot() +
  geom_regon(aes(x0 = runif(8), y0 = runif(8), sides = sample(3:10, 8),
                 angle = 0, r = runif(8) / 10),
             expand = unit(1, 'cm'), radius = unit(1, 'cm')) +
  coord_fixed()
}
