% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_statby.R
\name{desc_statby}
\alias{desc_statby}
\title{Descriptive statistics by groups}
\usage{
desc_statby(data, measure.var, grps, ci = 0.95)
}
\arguments{
\item{data}{a data frame.}

\item{measure.var}{the name of a column containing the variable to be summarized.}

\item{grps}{a character vector containing grouping variables; e.g.: grps = c("grp1", "grp2")}

\item{ci}{the percent range of the confidence interval (default is 0.95).}
}
\value{
A data frame containing descriptive statistics, such as:
\itemize{
\item \strong{length}: the number of elements in each group
\item \strong{min}: minimum
\item \strong{max}: maximum
\item \strong{median}: median
\item \strong{mean}: mean
\item \strong{iqr}: interquartile range
\item \strong{mad}: median absolute deviation (see ?MAD)
\item \strong{sd}: standard deviation of the sample
\item \strong{se}: standard error of the mean. It's calculated as the sample standard deviation divided by the root of the sample size.
\item \strong{ci}: confidence interval of the mean
\item \strong{range}: the range = max - min
\item \strong{cv}: coefficient of variation, sd/mean
\item \strong{var}: variance, sd^2
}
}
\description{
Computes descriptive statistics by groups for a measure variable.
}
\examples{
# Load data
data("ToothGrowth")

# Descriptive statistics
res <- desc_statby(ToothGrowth, measure.var = "len",
   grps = c("dose", "supp"))
head(res[, 1:10])

}
