% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loader.R
\name{loader}
\alias{loader}
\alias{path_loader}
\alias{package_loader}
\alias{list_loader}
\title{Template loaders}
\usage{
path_loader(...)

package_loader(package, ...)

list_loader(x)
}
\arguments{
\item{...}{Strings specifying path components.}

\item{package}{Name of the package in which to search.}

\item{x}{Named list mapping template names to template sources.}
}
\value{
A \code{"jinjar_loader"} object.
}
\description{
Loaders are responsible for exposing templates to the templating engine.

\code{path_loader()} loads templates from a directory in the file system.

\code{package_loader()} loads templates from a directory in an R package.

\code{list_loader()} loads templates from a named list.
}
\examples{
path_loader(getwd())

package_loader("base", "demo")

list_loader(list(
  header = "Title: {{ title }}",
  content = "Hello {{ person }}!"
))
}
\seealso{
The loader is an argument to \code{\link[=jinjar_config]{jinjar_config()}}.
}
