% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprintf_linter.R
\name{sprintf_linter}
\alias{sprintf_linter}
\title{Require correct \code{sprintf()} calls}
\usage{
sprintf_linter()
}
\description{
Check for an inconsistent number of arguments or arguments with incompatible types (for literal arguments) in
\code{\link[=sprintf]{sprintf()}} calls.
}
\details{
\code{\link[=gettextf]{gettextf()}} calls are also included, since \code{gettextf()} is a thin wrapper around \code{sprintf()}.
}
\examples{
# will produce lints
lint(
  text = 'sprintf("hello \%s \%s \%d", x, y)',
  linters = sprintf_linter()
)

# okay
lint(
  text = 'sprintf("hello \%s \%s \%d", x, y, z)',
  linters = sprintf_linter()
)

lint(
  text = 'sprintf("hello \%s \%s \%d", x, y, ...)',
  linters = sprintf_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=common_mistakes_linters]{common_mistakes}, \link[=correctness_linters]{correctness}
}
