% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distn.R
\name{InvGamma}
\alias{InvGamma}
\alias{dinvgamma}
\alias{rinvgamma}
\alias{dinvgamma}
\alias{rinvgamma}
\title{The Inverse Gamma Distribution}
\usage{
dinvgamma(x, shape, scale = 1)

rinvgamma(n, shape, scale = 1)
}
\arguments{
\item{x}{Scalar location to evaluate density.}

\item{shape}{Scalar shape parameter.}

\item{scale}{Scalar scale parameter (default value one).}

\item{n}{Number of draws from the distribution.}
}
\value{
\code{dinvgamma} evaluates the density at \code{x}.

\code{rinvgamma} takes \code{n} draws from the inverse Gamma distribution.
The parameterization is consistent with the Gamma Distribution in the stats
package.
}
\description{
Density function and random generation from the inverse gamma distribution.
}
\details{
An inverse gamma random variable with shape \eqn{a} and scale \eqn{b}
has mean \eqn{\frac{b}{a-1}} (assuming \eqn{a>1}) and variance
\eqn{\frac{b^2}{(a-1)^2(a-2)}} (assuming \eqn{a>2}).
}
\examples{

density <- dinvgamma(4.2, 1.1)
draws <- rinvgamma(10, 3.2)

}
\references{
Andrew Gelman, John B. Carlin, Hal S. Stern, and Donald B.
Rubin. 2004. \emph{Bayesian Data Analysis}. 2nd Edition. Boca Raton: Chapman
& Hall.
}
\seealso{
\code{\link[stats]{GammaDist}}
}
\keyword{distribution}
