% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{miniButtonBlock}
\alias{miniButtonBlock}
\title{Create a block-level button container}
\usage{
miniButtonBlock(..., border = "top")
}
\arguments{
\item{...}{One or more \code{\link[=shiny]{actionButton}} or
\code{\link[=shiny]{downloadButton}} objects.}

\item{border}{Zero or more of \code{c("top", "bottom")}, indicating which
sides should have borders, if any.}
}
\description{
Creates a full-width container for one or more buttons. The horizontal space
will be evenly divided among any buttons that are added.
}
\details{
When using \code{miniButtonBlock} with a \code{miniTabstripPanel}, consider
passing the \code{miniButtonBlock} to \code{miniTabstripPanel} as the
\code{between} argument.
}
\examples{
library(shiny)

miniButtonBlock(
  actionButton("reset", "Reset to defaults"),
  actionButton("clear", "Clear all")
)

}
\seealso{
For more information, see the
  \href{http://shiny.rstudio.com/articles/gadget-ui.html}{Designing
  Gadget UI} article on shiny.rstudio.com.
}

