% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\encoding{UTF-8}
\name{print.draws_rvars}
\alias{print.draws_rvars}
\title{Print \code{draws_rvars} objects}
\usage{
\method{print}{draws_rvars}(
  x,
  digits = 2,
  max_variables = getOption("posterior.max_variables", 8),
  summary = getOption("posterior.rvar_summary", "mean_sd"),
  reserved = FALSE,
  ...
)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{digits}{(nonnegative integer) The minimum number of significant digits
to print.}

\item{max_variables}{(positive integer) The maximum number of variables to
print. Can be controlled globally via the \code{"posterior.max_variables"}
\link[base:options]{option}.}

\item{summary}{(string) The style of summary to display: \code{"mean_sd"} displays
\verb{mean±sd}, \code{"median_mad"} displays \verb{median±mad}. If \code{NULL},
\code{getOption("posterior.rvar_summary")} is used (default \verb{"mean_sd}).}

\item{reserved}{(logical) Should reserved variables be included in the
output? Defaults to \code{FALSE}. See \code{\link{reserved_variables}} for an overview of
currently reserved variable names.}

\item{...}{Further arguments passed to the underlying \code{\link[=print]{print()}} methods.}
}
\value{
A \code{draws} object of the same class as \code{x}.
}
\description{
Pretty printing for \code{\link{draws_rvars}} objects.
}
\examples{
x <- as_draws_rvars(example_draws())
print(x)

}
