% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/python.R
\name{py_repr}
\alias{py_repr}
\alias{py_str}
\title{String representation of a python object.}
\usage{
py_repr(object)

py_str(object, ...)
}
\arguments{
\item{object}{Python object}

\item{...}{Unused}
}
\value{
Character vector
}
\description{
This is equivalent to calling \code{str(object)} or \code{repr(object)} in Python.
}
\details{
In Python, calling \code{print()} invokes the builtin \code{str()}, while auto-printing
an object at the REPL invokes the builtin \code{repr()}.

In \R, the default print method for python objects invokes \code{py_repr()}, and
the default \code{format()} and \code{as.character()} methods invoke \code{py_str()}.

For historical reasons, \code{py_str()} is also an \R S3 method that allows R
authors to customize the the string representation of a Python object from R.
New code is recommended to provide a \code{format()} and/or \code{print()} S3 R method
for python objects instead.

The default implementation will call \code{PyObject_Str} on the object.
}
