% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{env_has}
\alias{env_has}
\title{Does an environment have or see bindings?}
\usage{
env_has(env = caller_env(), nms, inherit = FALSE)
}
\arguments{
\item{env}{An environment or an object bundling an environment,
e.g. a formula, \link[=quotation]{quosure} or \link[=is_closure]{closure}.}

\item{nms}{A character vector containing the names of the bindings
to remove.}

\item{inherit}{Whether to look for bindings in the parent
environments.}
}
\value{
A logical vector as long as \code{nms}.
}
\description{
\code{env_has()} is a vectorised predicate that queries whether an
environment owns bindings personally (with \code{inherit} set to
\code{FALSE}, the default), or sees them in its own environment or in
any of its parents (with \code{inherit = TRUE}).
}
\examples{
parent <- child_env(NULL, foo = "foo")
env <- child_env(parent, bar = "bar")

# env does not own `foo` but sees it in its parent environment:
env_has(env, "foo")
env_has(env, "foo", inherit = TRUE)
}
