% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots.R, R/vec-new.R
\name{tidy-dots}
\alias{tidy-dots}
\alias{dots_list}
\alias{list2}
\title{Collect dots tidily}
\usage{
dots_list(..., .ignore_empty = c("trailing", "none", "all"))

list2(...)
}
\arguments{
\item{...}{Arguments with explicit (\code{dots_list()}) or list
(\code{dots_splice()}) splicing semantics. The contents of spliced
arguments are embedded in the returned list.}

\item{.ignore_empty}{Whether to ignore empty arguments. Can be one
of \code{"trailing"}, \code{"none"}, \code{"all"}. If \code{"trailing"}, only the
last argument is ignored if it is empty.}
}
\value{
A list of arguments. This list is always named: unnamed
arguments are named with the empty string \code{""}.
}
\description{
\code{list2()} is equivalent to \code{list(...)} but provides tidy
dots semantics:
\itemize{
\item You can splice other lists with the
\link[=quasiquotation]{unquote-splice} \code{!!!} operator.
\item You can unquote names by using the \link[=quasiquotation]{unquote}
operator \code{!!} on the left-hand side of \code{:=}.
}

We call quasiquotation support in dots \strong{tidy dots} semantics and
functions taking dots with \code{list2()} tidy dots functions.
Quasiquotation is an alternative to \code{do.call()} idioms and gives
the users of your functions an uniform syntax to supply a variable
number of arguments or a variable name.

\code{dots_list()} is a lower-level version of \code{list2()} that offers
additional parameters for dots capture.
}
\details{
Note that while all tidy eval \link[=quotation]{quoting functions} have
tidy dots semantics, not all tidy dots functions are quoting
functions. \code{list2()} is for standard functions, not quoting
functions.
}
\section{Life cycle}{


One difference of \code{dots_list()} with \code{list2()} is that it always
allocates a vector of names even if no names were supplied. In this
case, the names are all empty \code{""}. This is for consistency with
\code{\link[=enquos]{enquos()}} and \code{\link[=enexprs]{enexprs()}} but can be quite costly when long lists
are spliced in the results. For this reason we plan to parameterise
this behaviour with a \code{.named} argument and possibly change the
default. \code{list2()} does not have this issue.
}

\examples{
# Let's create a function that takes a variable number of arguments:
numeric <- function(...) {
  dots <- list2(...)
  num <- as.numeric(dots)
  set_names(num, names(dots))
}
numeric(1, 2, 3)

# The main difference with list(...) is that list2(...) enables
# the `!!!` syntax to splice lists:
x <- list(2, 3)
numeric(1, !!! x, 4)

# As well as unquoting of names:
nm <- "yup!"
numeric(!!nm := 1)


# One useful application of splicing is to work around exact and
# partial matching of arguments. Let's create a function taking
# named arguments and dots:
fn <- function(data, ...) {
  list2(...)
}

# You normally cannot pass an argument named `data` through the dots
# as it will match `fn`'s `data` argument. The splicing syntax
# provides a workaround:
fn("wrong!", data = letters)  # exact matching of `data`
fn("wrong!", dat = letters)   # partial matching of `data`
fn(some_data, !!! list(data = letters))  # no matching
}
\seealso{
\code{\link[=exprs]{exprs()}} for extracting dots without evaluation.
}
