% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic-nse.R
\name{topic-embrace-non-args}
\alias{topic-embrace-non-args}
\title{Does \verb{\{\{} work on regular objects?}
\description{
The embrace operator \ifelse{html}{\code{\link[=embrace-operator]{\{\{}}}{\verb{\{\{}} should be used exclusively with function arguments:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fn <- function(arg) \{
  quo(foo(\{\{ arg \}\}))
\}

fn(1 + 1)
#> <quosure>
#> expr: ^foo(^1 + 1)
#> env:  0x7ffd89aac518
}\if{html}{\out{</div>}}

However you may have noticed that it also works on regular objects:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fn <- function(arg) \{
  arg <- force(arg)
  quo(foo(\{\{ arg \}\}))
\}

fn(1 + 1)
#> <quosure>
#> expr: ^foo(^2)
#> env:  0x7ffd8a633398
}\if{html}{\out{</div>}}

In that case, \verb{\{\{} captures the \emph{value} of the expression instead of a defused expression. That's because only function arguments can be defused.

Note that this issue also applies to \code{\link[=enquo]{enquo()}} (on which \verb{\{\{} is based).
}
\section{Why is this not an error?}{
Ideally we would have made \verb{\{\{} on regular objects an error.  However this is not possible because in compiled R code it is not always possible to distinguish a regular variable from a function argument. See \ifelse{html}{\link[=topic-embrace-constants]{Why are strings and other constants enquosed in the empty environment?}}{\link[=topic-embrace-constants]{Why are strings and other constants enquosed in the empty environment?}} for more about this.
}

\keyword{internal}
