% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.save.R
\name{list.save}
\alias{list.save}
\title{Save a list to a file}
\usage{
list.save(x, file, type = tools::file_ext(file), ...)
}
\arguments{
\item{x}{The list to save}

\item{file}{The file for output}

\item{type}{The type of output which, by default, is determined
by file extension. Currently supports RData, RDS, JSON, YAML.}

\item{...}{Additional parameters passed to the output function}
}
\value{
\code{x} will be returned.
}
\description{
Save a list to a file
}
\examples{
\dontrun{
x <- lapply(1:5,function(i) data.frame(a=i,b=i^2))
list.save(x, 'list.rds')
list.save(x, 'list.rdata')
list.save(x, 'list.yaml')
list.save(x, 'list.json')
}
}

