% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcGraph.R
\name{mcGraph1}
\alias{mcGraph1}
\alias{mcGraph2}
\alias{mcGraph3}
\title{Illustrate multicollinearity in regression, part 1.}
\usage{
mcGraph1(x1, x2, y, x1lab, x2lab, ylab, ...)

mcGraph2(x1, x2, y, rescaley = 1, drawArrows = TRUE, x1lab, x2lab, ylab, ...)

mcGraph3(
  x1,
  x2,
  y,
  interaction = FALSE,
  drawArrows = TRUE,
  x1lab,
  x2lab,
  ylab,
  ...
)
}
\arguments{
\item{x1}{a predictor vector}

\item{x2}{a predictor vector}

\item{y}{the dependent variable}

\item{x1lab}{label for the x1 axis, (the one called "xlab" inside persp)}

\item{x2lab}{label for the x2 axis, (the one called "ylab" inside persp)}

\item{ylab}{label for the y (vertical) axis (the one called "zlab" inside persp)}

\item{...}{additional parameters passed to persp}

\item{rescaley}{a single scalar value or a vector of the same
length as y.}

\item{drawArrows}{TRUE or FALSE, do you want arrows from the plane to observed y?}

\item{interaction}{a TRUE or FALSE request for inclusion of the x1-x2 interaction in the regression calculation}
}
\value{
mcGraph1 and mcGraph2 return only the perspective matrix
from persp. It is returned so that users can add additional embellishments on the 3D plot (can be used with trans3d)

mcGraph3 returns a list of 2 objects. 1) the fitted
regression model2) the perspective matrix used with persp to draw
the image.
}
\description{
This is a set of functions that faciliates the examination
of multicollinearity. Suppose the "true" relationship is
 y[i] = 0.2 * x1[i] + 0.2 * x2[i] + e
where e is Normal(0, stde^2).

mcGraph1 draws the 3D regression space, but all of the points
are illustrated "in" the flat plane of x1-x2 variables.
}
\details{
These functions are specialized to a particular purpose. If you
just want to draw 3D regressions, look at plotPlane.
}
\examples{
set.seed(12345)
## Create data with x1 and x2 correlated at 0.10
dat <- genCorrelatedData(rho=.1, stde=7)

mcGraph1(dat$x1, dat$x2, dat$y, theta=20, phi=8, ticktype="detailed", nticks=10)

set.seed(12345)
## Create data with x1 and x2 correlated at 0.10
dat <- genCorrelatedData(rho=.1, stde=7)
## This will "grow" the "cloud" of points up from the
## x1-x2 axis
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 0.0, theta = 0)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 0.1, theta = 0)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 0.2, theta = 0)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 0.3, theta = 0)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 0.4, theta = 0)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 0.5, theta = 0)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 0.6, theta = 0)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 0.7, theta = 0)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 0.8, theta = 0)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 0.9, theta = 0)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 1, theta = 0)

##rotate this
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 1, theta = 20)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 1, theta = 40)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 1, theta = 60)
mcGraph2(dat$x1, dat$x2, dat$y, rescaley = 1, theta = 80)

## once they reach the top, make them glitter a while
for(i in 1:20){
  mcGraph2(dat$x1, dat$x2, dat$y, rescaley = runif(length(dat$x1), .9,1.1), theta = 0)
}

set.seed(12345)
## Create data with x1 and x2 correlated at 0.10
dat <- genCorrelatedData(rho=.1, stde=7)

mcGraph3(dat$x1, dat$x2, dat$y, theta = 0)

dat2 <- genCorrelatedData(rho = 0, stde = 7)

mcGraph3(dat2$x1, dat2$x2, dat2$y, theta = 0, phi = 10)
mcGraph3(dat2$x1, dat2$x2, dat2$y, theta = 30, phi = 10)
mcGraph3(dat2$x1, dat2$x2, dat2$y, theta = -30, phi = 10)
mcGraph3(dat2$x1, dat2$x2, dat2$y, theta = -30, phi = -10)
mcGraph3(dat2$x1, dat2$x2, dat2$y, theta = -30, phi = -15)

## Run regressions with not-strongly correlated data
modset1 <- list()
for(i in 1:20){
  dat2 <- genCorrelatedData(rho = .1, stde = 7)
  summary(lm( y ~ x1 + x2 , data = dat2))
  modset1[[i]] <- mcGraph3(dat2$x1, dat2$x2, dat2$y, theta = -30)
}


## Run regressions with strongly correlated data
modset2 <- list()
for(i in 1:20){
  dat2 <- genCorrelatedData(rho = .981, stde = 7)
  summary(lm( y ~ x1 + x2 , data = dat2))
  modset2[[i]] <- mcGraph3(dat2$x1, dat2$x2, dat2$y, theta = -30)
}

dat3 <- genCorrelatedData(rho = .981, stde = 100, beta=c(0.1, 0.2, 0.3, -0.1))
mcGraph3(dat3$x1, dat3$x2, dat3$y, theta=-10, interaction = TRUE)
}
\author{
Paul E. Johnson <pauljohn@ku.edu>
}
\keyword{hplot}
\keyword{regression}
