% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tol.R
\name{tol_subtree}
\alias{tol_subtree}
\title{Extract a subtree from the synthetic tree}
\usage{
tol_subtree(ott_id = NULL, node_id = NULL, label_format = NULL, file, ...)
}
\arguments{
\item{ott_id}{Numeric. The ott id of the node in the tree that should
serve as the root of the tree returned.}

\item{node_id}{Character. The node id of the node in the tree that should
serve as the root of the tree returned.}

\item{label_format}{Character. Defines the label type; one of
\dQuote{\code{name}}, \dQuote{\code{id}}, or
 \dQuote{\code{name_and_id}} (the default).}

\item{file}{If specified, the function will write the subtree to a
file in newick format.}

\item{...}{additional arguments to customize the API call (see
\code{\link{rotl}} for more information).}
}
\value{
If no value is specified to the \code{file} argument
    (default), a phylogenetic tree of class \code{phylo}.
    Otherwise, the function returns invisibly a logical indicating
    whether the file was successfully created.
}
\description{
Extract a subtree from the synthetic tree from an Open Tree node id.
}
\details{
Given a node, return the subtree of the synthetic tree descended
    from that node. The start node may be specified using either a node id
    or an ott id, but not both. If the specified node is not in the
    synthetic tree an error will be returned. There is a size limit of
    25000 tips for this method.
}
\examples{
\dontrun{
res <- tol_subtree(ott_id=241841)}
}
