% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ser_permutation_vector2matrix.R
\name{permutation_vector2matrix}
\alias{permutation_vector2matrix}
\alias{permutation_matrix2vector}
\title{Conversion Between Permutation Vector and Permutation Matrix}
\usage{
permutation_vector2matrix(x)

permutation_matrix2vector(x)
}
\arguments{
\item{x}{A permutation vector (any object that can be converted into a
permutation vector, e.g., a integer vector or a \code{hclust} object) or a
matrix representing a permutation. Arguments are checked.}
}
\value{
\itemize{
\item \code{permutation_vector2matrix()}: returns a permutation matrix.
\item \code{permutation_matrix2vector()}: returns the permutation as a integer vector.
}
}
\description{
Converts between permutation vectors and matrices.
}
\examples{
## create a random permutation vector
pv <- sample(1:5)
pv

## convert into a permutation matrix
pm <- permutation_vector2matrix(pv)
pm

## convert back
permutation_matrix2vector(pm)
}
\seealso{
Other permutation: 
\code{\link{get_order}()},
\code{\link{permute}()},
\code{\link{ser_dist}()},
\code{\link{ser_permutation_vector}()},
\code{\link{ser_permutation}()}
}
\author{
Michael Hahsler
}
\concept{permutation}
\keyword{manip}
