% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{Stdev}
\alias{Stdev}
\alias{Stdev.DimReduc}
\alias{Stdev.Seurat}
\title{Get the standard deviations for an object}
\usage{
Stdev(object, ...)

\method{Stdev}{DimReduc}(object, ...)

\method{Stdev}{Seurat}(object, reduction = "pca", ...)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{reduction}{Name of reduction to use}
}
\description{
Get the standard deviations for an object
}
\examples{
# Get the standard deviations for each PC from the DimReduc object
Stdev(object = pbmc_small[["pca"]])

# Get the standard deviations for each PC from the Seurat object
Stdev(object = pbmc_small, reduction = "pca")

}
