% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimreduc.R
\name{print.DimReduc}
\alias{print.DimReduc}
\alias{print}
\title{Print Top Feature Loadings}
\usage{
\method{print}{DimReduc}(x, dims = 1:5, nfeatures = 20, projected = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{DimReduc}} object}

\item{dims}{Number of dimensions to display}

\item{nfeatures}{Number of genes to display}

\item{projected}{Use projected slot}

\item{...}{Ignored}
}
\value{
Displays set of features defining the components and
invisibly returns \code{x}
}
\description{
Prints a set of features that most strongly define a set of components;
\strong{note}: requires feature loadings to be present in order to work
}
\examples{
pca <- pbmc_small[["pca"]]
print(pca)

}
\seealso{
\code{\link[base]{cat}}

Dimensional reduction object, validity, and interaction methods
\code{\link{CreateDimReducObject}()},
\code{\link{DimReduc-class}},
\code{\link{DimReduc-validity}},
\code{\link{[.DimReduc}()},
\code{\link{[[.DimReduc}()},
\code{\link{dim.DimReduc}()},
\code{\link{merge.DimReduc}()},
\code{\link{subset.DimReduc}()}
}
\concept{dimreduc}
