% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-pc-hazard.r
\name{sim.cause.cox}
\alias{sim.cause.cox}
\title{Simulation of cause specific from Cox models.}
\usage{
\method{sim}{cause.cox}(coxs, n, data = NULL, cens = NULL,
  rrc = NULL, ...)
}
\arguments{
\item{coxs}{list of cox models.}

\item{n}{number of simulations.}

\item{data}{to extract covariates for simulations (draws from observed
covariates).}

\item{cens}{specifies censoring model, if NULL then only censoring for 
  each cause at end of last event of this type. 
if "is.matrix" then uses cumulative. 
 hazard given, if "is.scalar" then uses rate for exponential, and if not
 given then takes average rate of in simulated data from cox model.
 But censoring can also be given as a cause.}

\item{rrc}{possible vector of relative risk for cox-type censoring.}

\item{...}{arguments for rchaz, for example entry-time}
}
\description{
Simulates data that looks like fit from cause specific Cox models. 
Censor data automatically. When censoring is given in the  list of causes this
will give censoring that looks like the data.  Covariates are drawn from data-set
with replacement. This gives covariates like the data.
}
\examples{

nsim <- 1000
data(bmt)
cox1 <- cox.aalen(Surv(time,cause==1)~prop(tcell)+prop(platelet),data=bmt,robust=0)
cox2 <- cox.aalen(Surv(time,cause==2)~prop(tcell)+prop(platelet),data=bmt,robust=0)
coxs <- list(cox1,cox2)
dd <- sim.cause.cox(coxs,nsim,data=bmt)
scox1 <- cox.aalen(Surv(time,status==1)~prop(tcell)+prop(platelet),data=dd,robust=0)
scox2 <- cox.aalen(Surv(time,status==2)~prop(tcell)+prop(platelet),data=dd,robust=0)
### 
cbind(cox1$gamma,scox1$gamma)
cbind(cox2$gamma,scox2$gamma)
par(mfrow=c(1,2))
plot(cox1); lines(scox1$cum,col=2)
plot(cox2$cum,type="l");
lines(scox2$cum,col=2)
          
          
\donttest{
### do not test to avoid dependence on mets
library(mets)          
data(bmt)
cox1 <- phreg(Surv(time,cause==1)~tcell+platelet,data=bmt)
cox2 <- phreg(Surv(time,cause==2)~tcell+platelet,data=bmt)
coxs <- list(cox1,cox2)
dd <- sim.cause.cox(coxs,nsim,data=bmt)
scox1 <- phreg(Surv(time,status==1)~tcell+platelet,data=dd)
scox2 <- phreg(Surv(time,status==2)~tcell+platelet,data=dd)
cbind(cox1$coef,scox1$coef)
cbind(cox2$coef,scox2$coef)
par(mfrow=c(1,2))
basehazplot.phreg(cox1); basehazplot.phreg(scox1,add=TRUE); 
basehazplot.phreg(cox2); basehazplot.phreg(scox2,add=TRUE); 

cox1 <- phreg(Surv(time,cause==1)~strata(tcell)+platelet,data=bmt)
cox2 <- phreg(Surv(time,cause==2)~strata(tcell)+platelet,data=bmt)
coxs <- list(cox1,cox2)
dd <- sim.cause.cox(coxs,nsim,data=bmt)
scox1 <- phreg(Surv(time,status==1)~strata(tcell)+platelet,data=dd)
scox2 <- phreg(Surv(time,status==2)~strata(tcell)+platelet,data=dd)
cbind(cox1$coef,scox1$coef)
cbind(cox2$coef,scox2$coef)
par(mfrow=c(1,2))
basehazplot.phreg(cox1); basehazplot.phreg(scox1,add=TRUE); 
basehazplot.phreg(cox2); basehazplot.phreg(scox2,add=TRUE); 

# coxph          
cox1 <- coxph(Surv(time,cause==1)~tcell+platelet,data=bmt)
cox2 <- coxph(Surv(time,cause==2)~tcell+platelet,data=bmt)
coxs <- list(cox1,cox2)
dd <- sim.cause.cox(coxs,nsim,data=bmt)
scox1 <- coxph(Surv(time,status==1)~tcell+platelet,data=dd)
scox2 <- coxph(Surv(time,status==2)~tcell+platelet,data=dd)
cbind(cox1$coef,scox1$coef)
cbind(cox2$coef,scox2$coef)
}  
}
\author{
Thomas Scheike
}
\keyword{survival}
