% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StubbedRequest.R
\name{StubbedRequest}
\alias{StubbedRequest}
\title{StubbedRequest}
\description{
stubbed request class underlying \code{\link[=stub_request]{stub_request()}}
}
\examples{
\dontrun{
x <- StubbedRequest$new(method = "get", uri = "api.crossref.org")
x$method
x$uri
x$with(headers = list('User-Agent' = 'R', apple = "good"))
x$to_return(status = 200, body = "foobar", headers = list(a = 5))
x
x$to_s()

# raw body
x <- StubbedRequest$new(method = "get", uri = "api.crossref.org")
x$to_return(status = 200, body = raw(0), headers = list(a = 5))
x$to_s()

# file path
x <- StubbedRequest$new(method = "get", uri = "api.crossref.org")
f <- tempfile()
x$to_return(status = 200, body = file(f), headers = list(a = 5))
x
x$to_s()
unlink(f)

# to_file(): file path and payload to go into the file
#   payload written to file during mocked response creation
x <- StubbedRequest$new(method = "get", uri = "api.crossref.org")
f <- tempfile()
x$to_return(status = 200, body = mock_file(f, "{\"foo\": \"bar\"}"),
  headers = list(a = 5))
x
x$to_s()
unlink(f)

# uri_regex
(x <- StubbedRequest$new(method = "get", uri_regex = ".+ossref.org"))
x$method
x$uri
x$to_s()

# to timeout
(x <- StubbedRequest$new(method = "get", uri_regex = ".+ossref.org"))
x$to_s()
x$to_timeout()
x$to_s()

# to raise
library(fauxpas)
(x <- StubbedRequest$new(method = "get", uri_regex = ".+ossref.org"))
x$to_s()
x$to_raise(HTTPBadGateway)
x$to_s()
}
}
\seealso{
\code{\link[=stub_request]{stub_request()}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{method}}{(xx) xx}

\item{\code{uri}}{(xx) xx}

\item{\code{uri_regex}}{(xx) xx}

\item{\code{uri_parts}}{(xx) xx}

\item{\code{host}}{(xx) xx}

\item{\code{query}}{(xx) xx}

\item{\code{body}}{(xx) xx}

\item{\code{request_headers}}{(xx) xx}

\item{\code{response_headers}}{(xx) xx}

\item{\code{responses_sequences}}{(xx) xx}

\item{\code{status_code}}{(xx) xx}

\item{\code{timeout}}{(xx) xx}

\item{\code{exceptions}}{(xx) xx}

\item{\code{raise}}{(xx) xx}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{StubbedRequest$new()}}
\item \href{#method-print}{\code{StubbedRequest$print()}}
\item \href{#method-with}{\code{StubbedRequest$with()}}
\item \href{#method-to_return}{\code{StubbedRequest$to_return()}}
\item \href{#method-to_timeout}{\code{StubbedRequest$to_timeout()}}
\item \href{#method-to_raise}{\code{StubbedRequest$to_raise()}}
\item \href{#method-to_s}{\code{StubbedRequest$to_s()}}
\item \href{#method-clone}{\code{StubbedRequest$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{StubbedRequest} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StubbedRequest$new(method, uri = NULL, uri_regex = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{the HTTP method (any, head, get, post, put,
patch, or delete). "any" matches any HTTP method. required.}

\item{\code{uri}}{(character) request URI. either this or \code{uri_regex}
required}

\item{\code{uri_regex}}{(character) request URI as regex. either this or \code{uri}
required}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{StubbedRequest} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
print method for the \code{StubbedRequest} class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StubbedRequest$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-with"></a>}}
\subsection{Method \code{with()}}{
Set expectations for what's given in HTTP request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StubbedRequest$with(query = NULL, body = NULL, headers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{(list) request query params, as a named list. optional}

\item{\code{body}}{(list) request body, as a named list. optional}

\item{\code{headers}}{(list) request headers as a named list. optional.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned; sets only
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_return"></a>}}
\subsection{Method \code{to_return()}}{
Set expectations for what's returned in HTTP response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StubbedRequest$to_return(status, body, headers)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{(numeric) an HTTP status code}

\item{\code{body}}{(list) response body, one of: \code{character}, \code{json},
\code{list}, \code{raw}, \code{numeric}, \code{NULL}, \code{FALSE}, or a file connection
(other connetion types not supported)}

\item{\code{headers}}{(list) named list, response headers. optional.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned; sets whats to be returned
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_timeout"></a>}}
\subsection{Method \code{to_timeout()}}{
Response should time out
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StubbedRequest$to_timeout()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
nothing returned
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_raise"></a>}}
\subsection{Method \code{to_raise()}}{
Response should raise an exception \code{x}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StubbedRequest$to_raise(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(character) an exception message}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_s"></a>}}
\subsection{Method \code{to_s()}}{
Response as a character string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StubbedRequest$to_s()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(character) the response as a string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StubbedRequest$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
