# Announce: Rakudo compiler, Release #149 (2021.08)

On behalf of the Rakudo development team, I’m very happy to announce the
August 2021 release of Rakudo #149. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2021.08:

  + Additions:
    + Enable rendering of nested blocks in the `Pod::To::Text` module [07517164][27f7924e][36de39f6]
  + Changes:
    + Raise priority of `let` and `temp` operators compared to `.=`, `.` and
      auto-increment, making `let $foo .= &{ Nil }` work more intuitively compared to
      `(let $foo) .= &{ Nil }` as was necessary before [ca40fca0][723e7488]
    + Change the `Scalar.WHICH` method implementation, fixing the semantics to reflect
      that `Scalar` is not a value object [56fce9e7]
  + Efficiency:
    + Make the `&&`, `||` and `//` operators about 2x as fast for the `+@a` candidates [db441c2c]
    + Improve performance of smartmatching between two `Signature` objects [66ae8612]
  + Fixes:
    + Fix some occurrences of hash-related concurrency issues [58ae9394]
    + Fix the `List.reduce` method when used with `&infix:<&&>` [ea389d66][db441c2c]
    + Fix matching of native types against roles `Numeric`, `Real` and `Stringy` [a8a78132]
    + Make `Pointer.Numeric` and `Pointer.Int` methods return 0 instead of resulting in an error [681e3b5e]
    + Fix a race in the `ClassHOW.new_type` method [08f5448d][83b0bca7]
  + Internal:
    + Make checking for Windows cheaper [89df7f4b]
    + Simplify `Rakudo::Iterator::While` iterator code [ffde2ba2]
    + Fix location of the `Proc.status` deprecation message [54f1b7a5]
    + Add tests to make sure float and double `NaN` can be passed to native code
      via NativeCall using the Raku `NaN` value [8ae6f394]


The following people contributed to this release:

Jonathan Worthington, Elizabeth Mattijsen, Vadim Belman, Oleksandr Kyriukhin,
Juan Julián Merelo Guervós, Will "Coke" Coleda, raydiak, Stoned Elipot, Ben Davies,
Daniel Green, Trey Harris, Gaeulbyul, Itsuki Toyota, Samantha McVey,
Stefan Seifert, V. N, Wenzel P. P. Peppmeyer

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2021 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#150), is tentatively scheduled for 2021-09-18.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
