
/**************************************************************************
 *                                                                        *
 *  Regina - A Normal Surface Theory Calculator                           *
 *  Python Interface                                                      *
 *                                                                        *
 *  Copyright (c) 1999-2022, Ben Burton                                   *
 *  For further details contact Ben Burton (bab@debian.org).              *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  As an exception, when this program is distributed through (i) the     *
 *  App Store by Apple Inc.; (ii) the Mac App Store by Apple Inc.; or     *
 *  (iii) Google Play by Google Inc., then that store may impose any      *
 *  digital rights management, device limits and/or redistribution        *
 *  restrictions that are required by its terms of service.               *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,       *
 *  MA 02110-1301, USA.                                                   *
 *                                                                        *
 **************************************************************************/

#include "../pybind11/pybind11.h"
#include "../pybind11/operators.h"
#include "../pybind11/stl.h"
#include "maths/perm.h"
#include "utilities/typeutils.h"
#include "../helpers.h"
#include "../helpers/arraylike.h"
#include "../docstrings/maths/perm4.h"

using regina::Perm;

void addPerm4(pybind11::module_& m) {
    RDOC_SCOPE_BEGIN(Perm)

    auto c = pybind11::class_<Perm<4>>(m, "Perm4", rdoc_scope)
        .def(pybind11::init<>(), rdoc::__default)
        .def(pybind11::init<int, int>(), rdoc::__init)
        .def(pybind11::init<int, int, int, int>(), rdoc::__init_2)
        .def(pybind11::init<const std::array<int, 4>&>(), rdoc::__init_3)
        .def(pybind11::init<int, int, int, int,
                            int, int, int, int>(), rdoc::__init_4)
        .def(pybind11::init<const Perm<4>&>(), rdoc::__copy)
        .def("permCode1", &Perm<4>::permCode1, rdoc::permCode1)
        .def("permCode2", &Perm<4>::permCode2, rdoc::permCode2)
        .def("setPermCode1", &Perm<4>::setPermCode1, rdoc::setPermCode1)
        .def("setPermCode2", &Perm<4>::setPermCode2, rdoc::setPermCode2)
        .def_static("fromPermCode1", &Perm<4>::fromPermCode1,
            rdoc::fromPermCode1)
        .def_static("fromPermCode2", &Perm<4>::fromPermCode2,
            rdoc::fromPermCode2)
        .def_static("isPermCode1", &Perm<4>::isPermCode1, rdoc::isPermCode1)
        .def_static("isPermCode2", &Perm<4>::isPermCode2, rdoc::isPermCode2)
        .def("imagePack", &Perm<4>::imagePack, rdoc::imagePack)
        .def_static("fromImagePack", &Perm<4>::fromImagePack,
            rdoc::fromImagePack)
        .def_static("isImagePack", &Perm<4>::isImagePack, rdoc::isImagePack)
        .def(pybind11::self * pybind11::self, rdoc::__mul)
        .def("inverse", &Perm<4>::inverse, rdoc::inverse)
        .def("pow", &Perm<4>::pow, rdoc::pow)
        .def("order", &Perm<4>::order, rdoc::order)
        .def("reverse", &Perm<4>::reverse, rdoc::reverse)
        .def("sign", &Perm<4>::sign, rdoc::sign)
        .def("__getitem__", &Perm<4>::operator[], rdoc::__array)
        .def("pre", &Perm<4>::pre, rdoc::pre)
        .def("compareWith", &Perm<4>::compareWith, rdoc::compareWith)
        .def("isIdentity", &Perm<4>::isIdentity, rdoc::isIdentity)
        .def("inc", [](Perm<4>& p) {
            return p++;
        }, rdoc::__inc)
        .def(pybind11::self < pybind11::self, rdoc::__lt)
        .def_static("rot", &Perm<4>::rot, rdoc::rot)
        .def_static("rand", static_cast<Perm<4>(&)(bool)>(Perm<4>::rand),
            pybind11::arg("even") = false, rdoc::rand)
        .def("trunc", &Perm<4>::trunc, rdoc::trunc)
        .def("trunc2", &Perm<4>::trunc2, rdoc::trunc2)
        .def("trunc3", &Perm<4>::trunc3, rdoc::trunc3)
        .def("clear", &Perm<4>::clear, rdoc::clear)
        .def("S4Index", static_cast<int (Perm<4>::*)() const>(
            &Perm<4>::S4Index), rdoc::S4Index)
        .def("SnIndex", &Perm<4>::SnIndex, rdoc::SnIndex)
        .def("orderedS4Index", &Perm<4>::orderedS4Index, rdoc::orderedS4Index)
        .def("orderedSnIndex", &Perm<4>::orderedSnIndex, rdoc::orderedSnIndex)
        .def("isConjugacyMinimal", &Perm<4>::isConjugacyMinimal,
            rdoc::isConjugacyMinimal)
        .def("pairs", &Perm<4>::pairs, rdoc::pairs)
        .def_static("extend", &Perm<4>::extend<2>, rdoc::extend)
        .def_static("extend", &Perm<4>::extend<3>, rdoc::extend)
        .def_readonly_static("codeType", &Perm<4>::codeType)
        .def_readonly_static("imageBits", &Perm<4>::imageBits)
        .def_readonly_static("imageMask", &Perm<4>::imageMask)
        .def_readonly_static("nPerms", &Perm<4>::nPerms)
        .def_readonly_static("nPerms_1", &Perm<4>::nPerms_1)
        .def_readonly_static("S4", &Perm<4>::S4)
        .def_readonly_static("Sn", &Perm<4>::Sn)
        .def_readonly_static("orderedS4", &Perm<4>::orderedS4)
        .def_readonly_static("orderedSn", &Perm<4>::orderedSn)
        .def_readonly_static("S3", &Perm<4>::S3)
        .def_readonly_static("Sn_1", &Perm<4>::Sn_1)
        .def_readonly_static("orderedS3", &Perm<4>::orderedS3)
        .def_readonly_static("S2", &Perm<4>::S2)
    ;
    regina::for_constexpr<5, 17>([&c](auto i) {
        c.def_static("contract", &Perm<4>::template contract<i.value>,
            rdoc::contract);
    });
    regina::python::add_output_basic(c, rdoc::str);
    regina::python::add_tight_encoding(c, rdoc::tightEncoding,
        rdoc::tightDecoding);
    regina::python::add_eq_operators(c, rdoc::__eq, rdoc::__ne);

    regina::python::add_lightweight_array<decltype(Perm<4>::S4)>(c,
        "_S4", rdoc::S4Lookup);
    regina::python::add_lightweight_array<decltype(Perm<4>::orderedS4)>(c,
        "_orderedS4", rdoc::OrderedS4Lookup);
    regina::python::add_lightweight_array<decltype(Perm<4>::S3)>(c,
        "_S3", rdoc::S3Lookup);
    regina::python::add_lightweight_array<decltype(Perm<4>::orderedS3)>(c,
        "_orderedS3", rdoc::OrderedS3Lookup);
    regina::python::add_lightweight_array<decltype(Perm<4>::S2)>(c,
        "_S2", rdoc::S2Lookup);

    RDOC_SCOPE_END
}

