#include "rheolef.h"
using namespace rheolef;
using namespace std;
size_t d;
Float epsilon;
Float u (const point& x) {
  Float x0 = (d <= 2) ? x[0] : x[1];
  if (x0 < Float(0.5)) 
    return x0*((1+3*epsilon)/(2*(1+epsilon)) - x0)/(2*epsilon);
  else
    return (1-x0)*(x0 + (1-epsilon)/(2*(1+epsilon)))/2;
}
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  Float error_linf_expected = (argc > 1) ? atof(argv[1]) : 1e+38;
  field uh;
  din >> catchmark("epsilon") >> epsilon
      >> catchmark("u")       >> uh;
  d = uh.get_geo().dimension();
  space Xh = uh.get_space();
  field pi_h_u = interpolate(Xh, u);
  field eh = pi_h_u - uh;
  trial u (Xh); test v (Xh);
  form m = integrate (u*v);
  derr << "error_linf "  << eh.max_abs() << endl
       << "error_l2   "  << sqrt(m(eh,eh)) << endl;
  return (eh.max_abs() < error_linf_expected) ? 0 : 1;
}
