#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"."}
TOP_SRCDIR=${TOP_SRCDIR-"../../../rheolef"}
NPROC_MAX=${NPROC_MAX-"8"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

status=0

run "../sbin/mkgeo_grid_2d -t 10 -rz -v4 2>/dev/null | ../pbin/geo -upgrade - > tmp.geo 2>/dev/null"
if test $? -ne 0; then status=1; fi

loop_mpirun "./boundary_domain_rz_tst tmp.geo > tmp_bdr.geo 2>/dev/null && sys_coord=\`grep coordinate_system tmp_bdr.geo | awk '{print \$2}'\` && test \$sys_coord = rz"
if test $? -ne 0; then status=1; fi

run "rm -f tmp_bdr.geo tmp.geo"

exit $status
