local({
## Prepare
require (tseries)
## Compute
vars <- rk.list (rock[["shape"]], rock[["perm"]])
results <- data.frame ("Variable Name"=I(names (vars)), check.names=FALSE)
for (i in 1:length (vars)) {
	var <- vars[[i]]
	results[i, "Length"] <- length (var)
	results[i, 'NAs'] <- sum (is.na(var))
	try ({
		test <- jarque.bera.test (na.omit (var))
		results[i, "Statistic"] <- paste (names (test$statistic), format (test$statistic), sep=" = ")
		results[i, 'df'] <- test$parameter
		results[i, "p-value"] <- test$p.value
	})
}
## Print result
rk.header ("Jarque-Bera Normality Test", parameters=list("Exclude NAs"="yes"))
rk.results (results)
})
