// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::X11Display;
use glib::{prelude::*, translate::*};
use std::fmt;
use x11::xlib;

glib::wrapper! {
    #[doc(alias = "GdkX11Window")]
    pub struct X11Window(Object<ffi::GdkX11Window, ffi::GdkX11WindowClass>) @extends gdk::Window;

    match fn {
        type_ => || ffi::gdk_x11_window_get_type(),
    }
}

impl X11Window {
    #[doc(alias = "gdk_x11_window_foreign_new_for_display")]
    pub fn foreign_new_for_display(display: &X11Display, window: xlib::Window) -> X11Window {
        skip_assert_initialized!();
        unsafe {
            gdk::Window::from_glib_full(ffi::gdk_x11_window_foreign_new_for_display(
                display.to_glib_none().0,
                window,
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "gdk_x11_window_get_desktop")]
    #[doc(alias = "get_desktop")]
    pub fn desktop(&self) -> u32 {
        unsafe { ffi::gdk_x11_window_get_desktop(self.to_glib_none().0) }
    }

    #[doc(alias = "gdk_x11_window_get_xid")]
    #[doc(alias = "get_xid")]
    pub fn xid(&self) -> xlib::Window {
        unsafe { ffi::gdk_x11_window_get_xid(self.to_glib_none().0) }
    }

    #[doc(alias = "gdk_x11_window_move_to_current_desktop")]
    pub fn move_to_current_desktop(&self) {
        unsafe {
            ffi::gdk_x11_window_move_to_current_desktop(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gdk_x11_window_move_to_desktop")]
    pub fn move_to_desktop(&self, desktop: u32) {
        unsafe {
            ffi::gdk_x11_window_move_to_desktop(self.to_glib_none().0, desktop);
        }
    }

    #[doc(alias = "gdk_x11_window_set_frame_sync_enabled")]
    pub fn set_frame_sync_enabled(&self, frame_sync_enabled: bool) {
        unsafe {
            ffi::gdk_x11_window_set_frame_sync_enabled(
                self.to_glib_none().0,
                frame_sync_enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "gdk_x11_window_set_hide_titlebar_when_maximized")]
    pub fn set_hide_titlebar_when_maximized(&self, hide_titlebar_when_maximized: bool) {
        unsafe {
            ffi::gdk_x11_window_set_hide_titlebar_when_maximized(
                self.to_glib_none().0,
                hide_titlebar_when_maximized.into_glib(),
            );
        }
    }

    #[doc(alias = "gdk_x11_window_set_theme_variant")]
    pub fn set_theme_variant(&self, variant: &str) {
        unsafe {
            ffi::gdk_x11_window_set_theme_variant(self.to_glib_none().0, variant.to_glib_none().0);
        }
    }

    #[doc(alias = "gdk_x11_window_set_user_time")]
    pub fn set_user_time(&self, timestamp: u32) {
        unsafe {
            ffi::gdk_x11_window_set_user_time(self.to_glib_none().0, timestamp);
        }
    }

    #[doc(alias = "gdk_x11_window_set_utf8_property")]
    pub fn set_utf8_property(&self, name: &str, value: Option<&str>) {
        unsafe {
            ffi::gdk_x11_window_set_utf8_property(
                self.to_glib_none().0,
                name.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gdk_x11_window_lookup_for_display")]
    pub fn lookup_for_display(display: &X11Display, window: xlib::Window) -> Option<X11Window> {
        skip_assert_initialized!();
        unsafe {
            from_glib_none(ffi::gdk_x11_window_lookup_for_display(
                display.to_glib_none().0,
                window,
            ))
        }
    }
}

impl fmt::Display for X11Window {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("X11Window")
    }
}
