// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::FileChooserAction;
use crate::FileChooserConfirmation;
use crate::FileFilter;
use crate::Widget;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GtkFileChooser")]
    pub struct FileChooser(Interface<ffi::GtkFileChooser>);

    match fn {
        type_ => || ffi::gtk_file_chooser_get_type(),
    }
}

pub const NONE_FILE_CHOOSER: Option<&FileChooser> = None;

pub trait FileChooserExt: 'static {
    #[doc(alias = "gtk_file_chooser_add_filter")]
    fn add_filter(&self, filter: &FileFilter);

    #[doc(alias = "gtk_file_chooser_add_shortcut_folder")]
    fn add_shortcut_folder<P: AsRef<std::path::Path>>(&self, folder: P) -> Result<(), glib::Error>;

    #[doc(alias = "gtk_file_chooser_add_shortcut_folder_uri")]
    fn add_shortcut_folder_uri(&self, uri: &str) -> Result<(), glib::Error>;

    #[doc(alias = "gtk_file_chooser_get_action")]
    #[doc(alias = "get_action")]
    fn action(&self) -> FileChooserAction;

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
    #[doc(alias = "gtk_file_chooser_get_choice")]
    #[doc(alias = "get_choice")]
    fn choice(&self, id: &str) -> Option<glib::GString>;

    #[doc(alias = "gtk_file_chooser_get_create_folders")]
    #[doc(alias = "get_create_folders")]
    fn creates_folders(&self) -> bool;

    #[doc(alias = "gtk_file_chooser_get_current_folder")]
    #[doc(alias = "get_current_folder")]
    fn current_folder(&self) -> Option<std::path::PathBuf>;

    #[doc(alias = "gtk_file_chooser_get_current_folder_file")]
    #[doc(alias = "get_current_folder_file")]
    fn current_folder_file(&self) -> Option<gio::File>;

    #[doc(alias = "gtk_file_chooser_get_current_folder_uri")]
    #[doc(alias = "get_current_folder_uri")]
    fn current_folder_uri(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_file_chooser_get_current_name")]
    #[doc(alias = "get_current_name")]
    fn current_name(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_file_chooser_get_do_overwrite_confirmation")]
    #[doc(alias = "get_do_overwrite_confirmation")]
    fn does_overwrite_confirmation(&self) -> bool;

    #[doc(alias = "gtk_file_chooser_get_extra_widget")]
    #[doc(alias = "get_extra_widget")]
    fn extra_widget(&self) -> Option<Widget>;

    #[doc(alias = "gtk_file_chooser_get_file")]
    #[doc(alias = "get_file")]
    fn file(&self) -> Option<gio::File>;

    #[doc(alias = "gtk_file_chooser_get_filename")]
    #[doc(alias = "get_filename")]
    fn filename(&self) -> Option<std::path::PathBuf>;

    #[doc(alias = "gtk_file_chooser_get_filenames")]
    #[doc(alias = "get_filenames")]
    fn filenames(&self) -> Vec<std::path::PathBuf>;

    #[doc(alias = "gtk_file_chooser_get_files")]
    #[doc(alias = "get_files")]
    fn files(&self) -> Vec<gio::File>;

    #[doc(alias = "gtk_file_chooser_get_filter")]
    #[doc(alias = "get_filter")]
    fn filter(&self) -> Option<FileFilter>;

    #[doc(alias = "gtk_file_chooser_get_local_only")]
    #[doc(alias = "get_local_only")]
    fn is_local_only(&self) -> bool;

    #[doc(alias = "gtk_file_chooser_get_preview_file")]
    #[doc(alias = "get_preview_file")]
    fn preview_file(&self) -> Option<gio::File>;

    #[doc(alias = "gtk_file_chooser_get_preview_filename")]
    #[doc(alias = "get_preview_filename")]
    fn preview_filename(&self) -> Option<std::path::PathBuf>;

    #[doc(alias = "gtk_file_chooser_get_preview_uri")]
    #[doc(alias = "get_preview_uri")]
    fn preview_uri(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_file_chooser_get_preview_widget")]
    #[doc(alias = "get_preview_widget")]
    fn preview_widget(&self) -> Option<Widget>;

    #[doc(alias = "gtk_file_chooser_get_preview_widget_active")]
    #[doc(alias = "get_preview_widget_active")]
    fn is_preview_widget_active(&self) -> bool;

    #[doc(alias = "gtk_file_chooser_get_select_multiple")]
    #[doc(alias = "get_select_multiple")]
    fn selects_multiple(&self) -> bool;

    #[doc(alias = "gtk_file_chooser_get_show_hidden")]
    #[doc(alias = "get_show_hidden")]
    fn shows_hidden(&self) -> bool;

    #[doc(alias = "gtk_file_chooser_get_uri")]
    #[doc(alias = "get_uri")]
    fn uri(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_file_chooser_get_uris")]
    #[doc(alias = "get_uris")]
    fn uris(&self) -> Vec<glib::GString>;

    #[doc(alias = "gtk_file_chooser_get_use_preview_label")]
    #[doc(alias = "get_use_preview_label")]
    fn uses_preview_label(&self) -> bool;

    #[doc(alias = "gtk_file_chooser_list_filters")]
    fn list_filters(&self) -> Vec<FileFilter>;

    #[doc(alias = "gtk_file_chooser_list_shortcut_folder_uris")]
    fn list_shortcut_folder_uris(&self) -> Vec<glib::GString>;

    #[doc(alias = "gtk_file_chooser_list_shortcut_folders")]
    fn list_shortcut_folders(&self) -> Vec<std::path::PathBuf>;

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
    #[doc(alias = "gtk_file_chooser_remove_choice")]
    fn remove_choice(&self, id: &str);

    #[doc(alias = "gtk_file_chooser_remove_filter")]
    fn remove_filter(&self, filter: &FileFilter);

    #[doc(alias = "gtk_file_chooser_remove_shortcut_folder")]
    fn remove_shortcut_folder<P: AsRef<std::path::Path>>(
        &self,
        folder: P,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "gtk_file_chooser_remove_shortcut_folder_uri")]
    fn remove_shortcut_folder_uri(&self, uri: &str) -> Result<(), glib::Error>;

    #[doc(alias = "gtk_file_chooser_select_all")]
    fn select_all(&self);

    #[doc(alias = "gtk_file_chooser_select_file")]
    fn select_file<P: IsA<gio::File>>(&self, file: &P) -> Result<(), glib::Error>;

    #[doc(alias = "gtk_file_chooser_select_filename")]
    fn select_filename<P: AsRef<std::path::Path>>(&self, filename: P) -> bool;

    #[doc(alias = "gtk_file_chooser_select_uri")]
    fn select_uri(&self, uri: &str) -> bool;

    #[doc(alias = "gtk_file_chooser_set_action")]
    fn set_action(&self, action: FileChooserAction);

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
    #[doc(alias = "gtk_file_chooser_set_choice")]
    fn set_choice(&self, id: &str, option: &str);

    #[doc(alias = "gtk_file_chooser_set_create_folders")]
    fn set_create_folders(&self, create_folders: bool);

    #[doc(alias = "gtk_file_chooser_set_current_folder")]
    fn set_current_folder<P: AsRef<std::path::Path>>(&self, filename: P) -> bool;

    #[doc(alias = "gtk_file_chooser_set_current_folder_file")]
    fn set_current_folder_file<P: IsA<gio::File>>(&self, file: &P) -> Result<(), glib::Error>;

    #[doc(alias = "gtk_file_chooser_set_current_folder_uri")]
    fn set_current_folder_uri(&self, uri: &str) -> bool;

    #[doc(alias = "gtk_file_chooser_set_current_name")]
    fn set_current_name(&self, name: &str);

    #[doc(alias = "gtk_file_chooser_set_do_overwrite_confirmation")]
    fn set_do_overwrite_confirmation(&self, do_overwrite_confirmation: bool);

    #[doc(alias = "gtk_file_chooser_set_extra_widget")]
    fn set_extra_widget<P: IsA<Widget>>(&self, extra_widget: &P);

    #[doc(alias = "gtk_file_chooser_set_file")]
    fn set_file<P: IsA<gio::File>>(&self, file: &P) -> Result<(), glib::Error>;

    #[doc(alias = "gtk_file_chooser_set_filename")]
    fn set_filename<P: AsRef<std::path::Path>>(&self, filename: P) -> bool;

    #[doc(alias = "gtk_file_chooser_set_filter")]
    fn set_filter(&self, filter: &FileFilter);

    #[doc(alias = "gtk_file_chooser_set_local_only")]
    fn set_local_only(&self, local_only: bool);

    #[doc(alias = "gtk_file_chooser_set_preview_widget")]
    fn set_preview_widget<P: IsA<Widget>>(&self, preview_widget: &P);

    #[doc(alias = "gtk_file_chooser_set_preview_widget_active")]
    fn set_preview_widget_active(&self, active: bool);

    #[doc(alias = "gtk_file_chooser_set_select_multiple")]
    fn set_select_multiple(&self, select_multiple: bool);

    #[doc(alias = "gtk_file_chooser_set_show_hidden")]
    fn set_show_hidden(&self, show_hidden: bool);

    #[doc(alias = "gtk_file_chooser_set_uri")]
    fn set_uri(&self, uri: &str) -> bool;

    #[doc(alias = "gtk_file_chooser_set_use_preview_label")]
    fn set_use_preview_label(&self, use_label: bool);

    #[doc(alias = "gtk_file_chooser_unselect_all")]
    fn unselect_all(&self);

    #[doc(alias = "gtk_file_chooser_unselect_file")]
    fn unselect_file<P: IsA<gio::File>>(&self, file: &P);

    #[doc(alias = "gtk_file_chooser_unselect_filename")]
    fn unselect_filename<P: AsRef<std::path::Path>>(&self, filename: P);

    #[doc(alias = "gtk_file_chooser_unselect_uri")]
    fn unselect_uri(&self, uri: &str);

    #[doc(alias = "confirm-overwrite")]
    fn connect_confirm_overwrite<F: Fn(&Self) -> FileChooserConfirmation + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "current-folder-changed")]
    fn connect_current_folder_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "file-activated")]
    fn connect_file_activated<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "selection-changed")]
    fn connect_selection_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "update-preview")]
    fn connect_update_preview<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "action")]
    fn connect_action_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "create-folders")]
    fn connect_create_folders_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "do-overwrite-confirmation")]
    fn connect_do_overwrite_confirmation_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "extra-widget")]
    fn connect_extra_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "filter")]
    fn connect_filter_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "local-only")]
    fn connect_local_only_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "preview-widget")]
    fn connect_preview_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "preview-widget-active")]
    fn connect_preview_widget_active_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "select-multiple")]
    fn connect_select_multiple_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show-hidden")]
    fn connect_show_hidden_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "use-preview-label")]
    fn connect_use_preview_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<FileChooser>> FileChooserExt for O {
    fn add_filter(&self, filter: &FileFilter) {
        unsafe {
            ffi::gtk_file_chooser_add_filter(self.as_ref().to_glib_none().0, filter.to_glib_full());
        }
    }

    fn add_shortcut_folder<P: AsRef<std::path::Path>>(&self, folder: P) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gtk_file_chooser_add_shortcut_folder(
                self.as_ref().to_glib_none().0,
                folder.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn add_shortcut_folder_uri(&self, uri: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gtk_file_chooser_add_shortcut_folder_uri(
                self.as_ref().to_glib_none().0,
                uri.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn action(&self) -> FileChooserAction {
        unsafe {
            from_glib(ffi::gtk_file_chooser_get_action(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
    fn choice(&self, id: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_file_chooser_get_choice(
                self.as_ref().to_glib_none().0,
                id.to_glib_none().0,
            ))
        }
    }

    fn creates_folders(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_get_create_folders(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn current_folder(&self) -> Option<std::path::PathBuf> {
        unsafe {
            from_glib_full(ffi::gtk_file_chooser_get_current_folder(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn current_folder_file(&self) -> Option<gio::File> {
        unsafe {
            from_glib_full(ffi::gtk_file_chooser_get_current_folder_file(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn current_folder_uri(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_file_chooser_get_current_folder_uri(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn current_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_file_chooser_get_current_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn does_overwrite_confirmation(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_get_do_overwrite_confirmation(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn extra_widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_file_chooser_get_extra_widget(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn file(&self) -> Option<gio::File> {
        unsafe {
            from_glib_full(ffi::gtk_file_chooser_get_file(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn filename(&self) -> Option<std::path::PathBuf> {
        unsafe {
            from_glib_full(ffi::gtk_file_chooser_get_filename(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn filenames(&self) -> Vec<std::path::PathBuf> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_file_chooser_get_filenames(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn files(&self) -> Vec<gio::File> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_file_chooser_get_files(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn filter(&self) -> Option<FileFilter> {
        unsafe {
            from_glib_none(ffi::gtk_file_chooser_get_filter(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_local_only(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_get_local_only(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn preview_file(&self) -> Option<gio::File> {
        unsafe {
            from_glib_full(ffi::gtk_file_chooser_get_preview_file(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn preview_filename(&self) -> Option<std::path::PathBuf> {
        unsafe {
            from_glib_full(ffi::gtk_file_chooser_get_preview_filename(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn preview_uri(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_file_chooser_get_preview_uri(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn preview_widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_file_chooser_get_preview_widget(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_preview_widget_active(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_get_preview_widget_active(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn selects_multiple(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_get_select_multiple(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn shows_hidden(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_get_show_hidden(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn uri(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_file_chooser_get_uri(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn uris(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_file_chooser_get_uris(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn uses_preview_label(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_get_use_preview_label(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn list_filters(&self) -> Vec<FileFilter> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_file_chooser_list_filters(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn list_shortcut_folder_uris(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_file_chooser_list_shortcut_folder_uris(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn list_shortcut_folders(&self) -> Vec<std::path::PathBuf> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_file_chooser_list_shortcut_folders(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
    fn remove_choice(&self, id: &str) {
        unsafe {
            ffi::gtk_file_chooser_remove_choice(
                self.as_ref().to_glib_none().0,
                id.to_glib_none().0,
            );
        }
    }

    fn remove_filter(&self, filter: &FileFilter) {
        unsafe {
            ffi::gtk_file_chooser_remove_filter(
                self.as_ref().to_glib_none().0,
                filter.to_glib_none().0,
            );
        }
    }

    fn remove_shortcut_folder<P: AsRef<std::path::Path>>(
        &self,
        folder: P,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gtk_file_chooser_remove_shortcut_folder(
                self.as_ref().to_glib_none().0,
                folder.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn remove_shortcut_folder_uri(&self, uri: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gtk_file_chooser_remove_shortcut_folder_uri(
                self.as_ref().to_glib_none().0,
                uri.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn select_all(&self) {
        unsafe {
            ffi::gtk_file_chooser_select_all(self.as_ref().to_glib_none().0);
        }
    }

    fn select_file<P: IsA<gio::File>>(&self, file: &P) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gtk_file_chooser_select_file(
                self.as_ref().to_glib_none().0,
                file.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn select_filename<P: AsRef<std::path::Path>>(&self, filename: P) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_select_filename(
                self.as_ref().to_glib_none().0,
                filename.as_ref().to_glib_none().0,
            ))
        }
    }

    fn select_uri(&self, uri: &str) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_select_uri(
                self.as_ref().to_glib_none().0,
                uri.to_glib_none().0,
            ))
        }
    }

    fn set_action(&self, action: FileChooserAction) {
        unsafe {
            ffi::gtk_file_chooser_set_action(self.as_ref().to_glib_none().0, action.into_glib());
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
    fn set_choice(&self, id: &str, option: &str) {
        unsafe {
            ffi::gtk_file_chooser_set_choice(
                self.as_ref().to_glib_none().0,
                id.to_glib_none().0,
                option.to_glib_none().0,
            );
        }
    }

    fn set_create_folders(&self, create_folders: bool) {
        unsafe {
            ffi::gtk_file_chooser_set_create_folders(
                self.as_ref().to_glib_none().0,
                create_folders.into_glib(),
            );
        }
    }

    fn set_current_folder<P: AsRef<std::path::Path>>(&self, filename: P) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_set_current_folder(
                self.as_ref().to_glib_none().0,
                filename.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_current_folder_file<P: IsA<gio::File>>(&self, file: &P) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gtk_file_chooser_set_current_folder_file(
                self.as_ref().to_glib_none().0,
                file.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_current_folder_uri(&self, uri: &str) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_set_current_folder_uri(
                self.as_ref().to_glib_none().0,
                uri.to_glib_none().0,
            ))
        }
    }

    fn set_current_name(&self, name: &str) {
        unsafe {
            ffi::gtk_file_chooser_set_current_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            );
        }
    }

    fn set_do_overwrite_confirmation(&self, do_overwrite_confirmation: bool) {
        unsafe {
            ffi::gtk_file_chooser_set_do_overwrite_confirmation(
                self.as_ref().to_glib_none().0,
                do_overwrite_confirmation.into_glib(),
            );
        }
    }

    fn set_extra_widget<P: IsA<Widget>>(&self, extra_widget: &P) {
        unsafe {
            ffi::gtk_file_chooser_set_extra_widget(
                self.as_ref().to_glib_none().0,
                extra_widget.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_file<P: IsA<gio::File>>(&self, file: &P) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gtk_file_chooser_set_file(
                self.as_ref().to_glib_none().0,
                file.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_filename<P: AsRef<std::path::Path>>(&self, filename: P) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_set_filename(
                self.as_ref().to_glib_none().0,
                filename.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_filter(&self, filter: &FileFilter) {
        unsafe {
            ffi::gtk_file_chooser_set_filter(
                self.as_ref().to_glib_none().0,
                filter.to_glib_none().0,
            );
        }
    }

    fn set_local_only(&self, local_only: bool) {
        unsafe {
            ffi::gtk_file_chooser_set_local_only(
                self.as_ref().to_glib_none().0,
                local_only.into_glib(),
            );
        }
    }

    fn set_preview_widget<P: IsA<Widget>>(&self, preview_widget: &P) {
        unsafe {
            ffi::gtk_file_chooser_set_preview_widget(
                self.as_ref().to_glib_none().0,
                preview_widget.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_preview_widget_active(&self, active: bool) {
        unsafe {
            ffi::gtk_file_chooser_set_preview_widget_active(
                self.as_ref().to_glib_none().0,
                active.into_glib(),
            );
        }
    }

    fn set_select_multiple(&self, select_multiple: bool) {
        unsafe {
            ffi::gtk_file_chooser_set_select_multiple(
                self.as_ref().to_glib_none().0,
                select_multiple.into_glib(),
            );
        }
    }

    fn set_show_hidden(&self, show_hidden: bool) {
        unsafe {
            ffi::gtk_file_chooser_set_show_hidden(
                self.as_ref().to_glib_none().0,
                show_hidden.into_glib(),
            );
        }
    }

    fn set_uri(&self, uri: &str) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_chooser_set_uri(
                self.as_ref().to_glib_none().0,
                uri.to_glib_none().0,
            ))
        }
    }

    fn set_use_preview_label(&self, use_label: bool) {
        unsafe {
            ffi::gtk_file_chooser_set_use_preview_label(
                self.as_ref().to_glib_none().0,
                use_label.into_glib(),
            );
        }
    }

    fn unselect_all(&self) {
        unsafe {
            ffi::gtk_file_chooser_unselect_all(self.as_ref().to_glib_none().0);
        }
    }

    fn unselect_file<P: IsA<gio::File>>(&self, file: &P) {
        unsafe {
            ffi::gtk_file_chooser_unselect_file(
                self.as_ref().to_glib_none().0,
                file.as_ref().to_glib_none().0,
            );
        }
    }

    fn unselect_filename<P: AsRef<std::path::Path>>(&self, filename: P) {
        unsafe {
            ffi::gtk_file_chooser_unselect_filename(
                self.as_ref().to_glib_none().0,
                filename.as_ref().to_glib_none().0,
            );
        }
    }

    fn unselect_uri(&self, uri: &str) {
        unsafe {
            ffi::gtk_file_chooser_unselect_uri(
                self.as_ref().to_glib_none().0,
                uri.to_glib_none().0,
            );
        }
    }

    fn connect_confirm_overwrite<F: Fn(&Self) -> FileChooserConfirmation + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn confirm_overwrite_trampoline<
            P: IsA<FileChooser>,
            F: Fn(&P) -> FileChooserConfirmation + 'static,
        >(
            this: *mut ffi::GtkFileChooser,
            f: glib::ffi::gpointer,
        ) -> ffi::GtkFileChooserConfirmation {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"confirm-overwrite\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    confirm_overwrite_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_current_folder_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn current_folder_changed_trampoline<
            P: IsA<FileChooser>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFileChooser,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"current-folder-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    current_folder_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_file_activated<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn file_activated_trampoline<P: IsA<FileChooser>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkFileChooser,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"file-activated\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    file_activated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_selection_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn selection_changed_trampoline<
            P: IsA<FileChooser>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFileChooser,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"selection-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    selection_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_update_preview<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn update_preview_trampoline<P: IsA<FileChooser>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkFileChooser,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"update-preview\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    update_preview_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_action_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_action_trampoline<P: IsA<FileChooser>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkFileChooser,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::action\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_action_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_create_folders_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_create_folders_trampoline<
            P: IsA<FileChooser>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFileChooser,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::create-folders\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_create_folders_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_do_overwrite_confirmation_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_do_overwrite_confirmation_trampoline<
            P: IsA<FileChooser>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFileChooser,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::do-overwrite-confirmation\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_do_overwrite_confirmation_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_extra_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_extra_widget_trampoline<
            P: IsA<FileChooser>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFileChooser,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::extra-widget\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_extra_widget_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_filter_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_filter_trampoline<P: IsA<FileChooser>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkFileChooser,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::filter\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_filter_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_local_only_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_local_only_trampoline<
            P: IsA<FileChooser>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFileChooser,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::local-only\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_local_only_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_preview_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_preview_widget_trampoline<
            P: IsA<FileChooser>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFileChooser,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::preview-widget\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_preview_widget_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_preview_widget_active_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_preview_widget_active_trampoline<
            P: IsA<FileChooser>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFileChooser,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::preview-widget-active\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_preview_widget_active_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_select_multiple_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_select_multiple_trampoline<
            P: IsA<FileChooser>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFileChooser,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::select-multiple\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_select_multiple_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_hidden_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_hidden_trampoline<
            P: IsA<FileChooser>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFileChooser,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-hidden\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_hidden_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_use_preview_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_preview_label_trampoline<
            P: IsA<FileChooser>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkFileChooser,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileChooser::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::use-preview-label\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_use_preview_label_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for FileChooser {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("FileChooser")
    }
}
