// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{HoverContext, HoverDisplay};
use glib::{prelude::*, translate::*};
use std::{boxed::Box as Box_, pin::Pin};

glib::wrapper! {
    #[doc(alias = "GtkSourceHoverProvider")]
    pub struct HoverProvider(Interface<ffi::GtkSourceHoverProvider, ffi::GtkSourceHoverProviderInterface>);

    match fn {
        type_ => || ffi::gtk_source_hover_provider_get_type(),
    }
}

impl HoverProvider {
    pub const NONE: Option<&'static HoverProvider> = None;
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::HoverProvider>> Sealed for T {}
}

pub trait HoverProviderExt: IsA<HoverProvider> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_source_hover_provider_populate_async")]
    fn populate_async<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        context: &HoverContext,
        display: &HoverDisplay,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn populate_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = std::ptr::null_mut();
            let _ = ffi::gtk_source_hover_provider_populate_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = populate_async_trampoline::<P>;
        unsafe {
            ffi::gtk_source_hover_provider_populate_async(
                self.as_ref().to_glib_none().0,
                context.to_glib_none().0,
                display.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn populate_future(
        &self,
        context: &HoverContext,
        display: &HoverDisplay,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let context = context.clone();
        let display = display.clone();
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.populate_async(&context, &display, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }
}

impl<O: IsA<HoverProvider>> HoverProviderExt for O {}
