// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{
    BackgroundPatternType, Buffer, ChangeCaseType, Completion, Gutter, Hover, Indenter,
    MarkAttributes, SmartHomeEndType, SpaceDrawer,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkSourceView")]
    pub struct View(Object<ffi::GtkSourceView, ffi::GtkSourceViewClass>) @extends gtk::TextView, gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget, gtk::Scrollable;

    match fn {
        type_ => || ffi::gtk_source_view_get_type(),
    }
}

impl View {
    pub const NONE: Option<&'static View> = None;

    #[doc(alias = "gtk_source_view_new")]
    pub fn new() -> View {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::gtk_source_view_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_source_view_new_with_buffer")]
    #[doc(alias = "new_with_buffer")]
    pub fn with_buffer(buffer: &impl IsA<Buffer>) -> View {
        skip_assert_initialized!();
        unsafe {
            gtk::Widget::from_glib_none(ffi::gtk_source_view_new_with_buffer(
                buffer.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`View`] objects.
    ///
    /// This method returns an instance of [`ViewBuilder`](crate::builders::ViewBuilder) which can be used to create [`View`] objects.
    pub fn builder() -> ViewBuilder {
        ViewBuilder::new()
    }
}

impl Default for View {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`View`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ViewBuilder {
    builder: glib::object::ObjectBuilder<'static, View>,
}

impl ViewBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn auto_indent(self, auto_indent: bool) -> Self {
        Self {
            builder: self.builder.property("auto-indent", auto_indent),
        }
    }

    pub fn background_pattern(self, background_pattern: BackgroundPatternType) -> Self {
        Self {
            builder: self
                .builder
                .property("background-pattern", background_pattern),
        }
    }

    pub fn enable_snippets(self, enable_snippets: bool) -> Self {
        Self {
            builder: self.builder.property("enable-snippets", enable_snippets),
        }
    }

    pub fn highlight_current_line(self, highlight_current_line: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("highlight-current-line", highlight_current_line),
        }
    }

    pub fn indent_on_tab(self, indent_on_tab: bool) -> Self {
        Self {
            builder: self.builder.property("indent-on-tab", indent_on_tab),
        }
    }

    pub fn indent_width(self, indent_width: i32) -> Self {
        Self {
            builder: self.builder.property("indent-width", indent_width),
        }
    }

    pub fn indenter(self, indenter: &impl IsA<Indenter>) -> Self {
        Self {
            builder: self.builder.property("indenter", indenter.clone().upcast()),
        }
    }

    pub fn insert_spaces_instead_of_tabs(self, insert_spaces_instead_of_tabs: bool) -> Self {
        Self {
            builder: self.builder.property(
                "insert-spaces-instead-of-tabs",
                insert_spaces_instead_of_tabs,
            ),
        }
    }

    pub fn right_margin_position(self, right_margin_position: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("right-margin-position", right_margin_position),
        }
    }

    pub fn show_line_marks(self, show_line_marks: bool) -> Self {
        Self {
            builder: self.builder.property("show-line-marks", show_line_marks),
        }
    }

    pub fn show_line_numbers(self, show_line_numbers: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("show-line-numbers", show_line_numbers),
        }
    }

    pub fn show_right_margin(self, show_right_margin: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("show-right-margin", show_right_margin),
        }
    }

    pub fn smart_backspace(self, smart_backspace: bool) -> Self {
        Self {
            builder: self.builder.property("smart-backspace", smart_backspace),
        }
    }

    pub fn smart_home_end(self, smart_home_end: SmartHomeEndType) -> Self {
        Self {
            builder: self.builder.property("smart-home-end", smart_home_end),
        }
    }

    pub fn tab_width(self, tab_width: u32) -> Self {
        Self {
            builder: self.builder.property("tab-width", tab_width),
        }
    }

    pub fn accepts_tab(self, accepts_tab: bool) -> Self {
        Self {
            builder: self.builder.property("accepts-tab", accepts_tab),
        }
    }

    pub fn bottom_margin(self, bottom_margin: i32) -> Self {
        Self {
            builder: self.builder.property("bottom-margin", bottom_margin),
        }
    }

    pub fn buffer(self, buffer: &impl IsA<gtk::TextBuffer>) -> Self {
        Self {
            builder: self.builder.property("buffer", buffer.clone().upcast()),
        }
    }

    pub fn cursor_visible(self, cursor_visible: bool) -> Self {
        Self {
            builder: self.builder.property("cursor-visible", cursor_visible),
        }
    }

    pub fn editable(self, editable: bool) -> Self {
        Self {
            builder: self.builder.property("editable", editable),
        }
    }

    pub fn extra_menu(self, extra_menu: &impl IsA<gio::MenuModel>) -> Self {
        Self {
            builder: self
                .builder
                .property("extra-menu", extra_menu.clone().upcast()),
        }
    }

    pub fn im_module(self, im_module: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("im-module", im_module.into()),
        }
    }

    pub fn indent(self, indent: i32) -> Self {
        Self {
            builder: self.builder.property("indent", indent),
        }
    }

    pub fn input_hints(self, input_hints: gtk::InputHints) -> Self {
        Self {
            builder: self.builder.property("input-hints", input_hints),
        }
    }

    pub fn input_purpose(self, input_purpose: gtk::InputPurpose) -> Self {
        Self {
            builder: self.builder.property("input-purpose", input_purpose),
        }
    }

    pub fn justification(self, justification: gtk::Justification) -> Self {
        Self {
            builder: self.builder.property("justification", justification),
        }
    }

    pub fn left_margin(self, left_margin: i32) -> Self {
        Self {
            builder: self.builder.property("left-margin", left_margin),
        }
    }

    pub fn monospace(self, monospace: bool) -> Self {
        Self {
            builder: self.builder.property("monospace", monospace),
        }
    }

    pub fn overwrite(self, overwrite: bool) -> Self {
        Self {
            builder: self.builder.property("overwrite", overwrite),
        }
    }

    pub fn pixels_above_lines(self, pixels_above_lines: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-above-lines", pixels_above_lines),
        }
    }

    pub fn pixels_below_lines(self, pixels_below_lines: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-below-lines", pixels_below_lines),
        }
    }

    pub fn pixels_inside_wrap(self, pixels_inside_wrap: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-inside-wrap", pixels_inside_wrap),
        }
    }

    pub fn right_margin(self, right_margin: i32) -> Self {
        Self {
            builder: self.builder.property("right-margin", right_margin),
        }
    }

    pub fn tabs(self, tabs: &pango::TabArray) -> Self {
        Self {
            builder: self.builder.property("tabs", tabs),
        }
    }

    pub fn top_margin(self, top_margin: i32) -> Self {
        Self {
            builder: self.builder.property("top-margin", top_margin),
        }
    }

    pub fn wrap_mode(self, wrap_mode: gtk::WrapMode) -> Self {
        Self {
            builder: self.builder.property("wrap-mode", wrap_mode),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    pub fn hadjustment(self, hadjustment: &impl IsA<gtk::Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("hadjustment", hadjustment.clone().upcast()),
        }
    }

    pub fn hscroll_policy(self, hscroll_policy: gtk::ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("hscroll-policy", hscroll_policy),
        }
    }

    pub fn vadjustment(self, vadjustment: &impl IsA<gtk::Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("vadjustment", vadjustment.clone().upcast()),
        }
    }

    pub fn vscroll_policy(self, vscroll_policy: gtk::ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("vscroll-policy", vscroll_policy),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`View`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> View {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::View>> Sealed for T {}
}

pub trait ViewExt: IsA<View> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_source_view_get_auto_indent")]
    #[doc(alias = "get_auto_indent")]
    fn is_auto_indent(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_auto_indent(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_background_pattern")]
    #[doc(alias = "get_background_pattern")]
    fn background_pattern(&self) -> BackgroundPatternType {
        unsafe {
            from_glib(ffi::gtk_source_view_get_background_pattern(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_completion")]
    #[doc(alias = "get_completion")]
    fn completion(&self) -> Completion {
        unsafe {
            from_glib_none(ffi::gtk_source_view_get_completion(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_enable_snippets")]
    #[doc(alias = "get_enable_snippets")]
    fn enables_snippets(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_enable_snippets(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_gutter")]
    #[doc(alias = "get_gutter")]
    fn gutter(&self, window_type: gtk::TextWindowType) -> Gutter {
        unsafe {
            from_glib_none(ffi::gtk_source_view_get_gutter(
                self.as_ref().to_glib_none().0,
                window_type.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_highlight_current_line")]
    #[doc(alias = "get_highlight_current_line")]
    fn is_highlight_current_line(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_highlight_current_line(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_hover")]
    #[doc(alias = "get_hover")]
    fn hover(&self) -> Hover {
        unsafe {
            from_glib_none(ffi::gtk_source_view_get_hover(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_indent_on_tab")]
    #[doc(alias = "get_indent_on_tab")]
    fn is_indent_on_tab(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_indent_on_tab(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_indent_width")]
    #[doc(alias = "get_indent_width")]
    fn indent_width(&self) -> i32 {
        unsafe { ffi::gtk_source_view_get_indent_width(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_source_view_get_indenter")]
    #[doc(alias = "get_indenter")]
    fn indenter(&self) -> Option<Indenter> {
        unsafe {
            from_glib_none(ffi::gtk_source_view_get_indenter(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_insert_spaces_instead_of_tabs")]
    #[doc(alias = "get_insert_spaces_instead_of_tabs")]
    fn is_insert_spaces_instead_of_tabs(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_insert_spaces_instead_of_tabs(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_right_margin_position")]
    #[doc(alias = "get_right_margin_position")]
    fn right_margin_position(&self) -> u32 {
        unsafe { ffi::gtk_source_view_get_right_margin_position(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_source_view_get_show_line_marks")]
    #[doc(alias = "get_show_line_marks")]
    fn shows_line_marks(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_show_line_marks(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_show_line_numbers")]
    #[doc(alias = "get_show_line_numbers")]
    fn shows_line_numbers(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_show_line_numbers(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_show_right_margin")]
    #[doc(alias = "get_show_right_margin")]
    fn shows_right_margin(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_show_right_margin(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_smart_backspace")]
    #[doc(alias = "get_smart_backspace")]
    fn is_smart_backspace(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_smart_backspace(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_smart_home_end")]
    #[doc(alias = "get_smart_home_end")]
    fn smart_home_end(&self) -> SmartHomeEndType {
        unsafe {
            from_glib(ffi::gtk_source_view_get_smart_home_end(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_space_drawer")]
    #[doc(alias = "get_space_drawer")]
    fn space_drawer(&self) -> SpaceDrawer {
        unsafe {
            from_glib_none(ffi::gtk_source_view_get_space_drawer(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_view_get_tab_width")]
    #[doc(alias = "get_tab_width")]
    fn tab_width(&self) -> u32 {
        unsafe { ffi::gtk_source_view_get_tab_width(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_source_view_get_visual_column")]
    #[doc(alias = "get_visual_column")]
    fn visual_column(&self, iter: &gtk::TextIter) -> u32 {
        unsafe {
            ffi::gtk_source_view_get_visual_column(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
            )
        }
    }

    #[doc(alias = "gtk_source_view_indent_lines")]
    fn indent_lines(&self, start: &mut gtk::TextIter, end: &mut gtk::TextIter) {
        unsafe {
            ffi::gtk_source_view_indent_lines(
                self.as_ref().to_glib_none().0,
                start.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_auto_indent")]
    fn set_auto_indent(&self, enable: bool) {
        unsafe {
            ffi::gtk_source_view_set_auto_indent(
                self.as_ref().to_glib_none().0,
                enable.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_background_pattern")]
    fn set_background_pattern(&self, background_pattern: BackgroundPatternType) {
        unsafe {
            ffi::gtk_source_view_set_background_pattern(
                self.as_ref().to_glib_none().0,
                background_pattern.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_enable_snippets")]
    fn set_enable_snippets(&self, enable_snippets: bool) {
        unsafe {
            ffi::gtk_source_view_set_enable_snippets(
                self.as_ref().to_glib_none().0,
                enable_snippets.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_highlight_current_line")]
    fn set_highlight_current_line(&self, highlight: bool) {
        unsafe {
            ffi::gtk_source_view_set_highlight_current_line(
                self.as_ref().to_glib_none().0,
                highlight.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_indent_on_tab")]
    fn set_indent_on_tab(&self, enable: bool) {
        unsafe {
            ffi::gtk_source_view_set_indent_on_tab(
                self.as_ref().to_glib_none().0,
                enable.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_indent_width")]
    fn set_indent_width(&self, width: i32) {
        unsafe {
            ffi::gtk_source_view_set_indent_width(self.as_ref().to_glib_none().0, width);
        }
    }

    #[doc(alias = "gtk_source_view_set_indenter")]
    fn set_indenter(&self, indenter: Option<&impl IsA<Indenter>>) {
        unsafe {
            ffi::gtk_source_view_set_indenter(
                self.as_ref().to_glib_none().0,
                indenter.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_insert_spaces_instead_of_tabs")]
    fn set_insert_spaces_instead_of_tabs(&self, enable: bool) {
        unsafe {
            ffi::gtk_source_view_set_insert_spaces_instead_of_tabs(
                self.as_ref().to_glib_none().0,
                enable.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_mark_attributes")]
    fn set_mark_attributes(&self, category: &str, attributes: &MarkAttributes, priority: i32) {
        unsafe {
            ffi::gtk_source_view_set_mark_attributes(
                self.as_ref().to_glib_none().0,
                category.to_glib_none().0,
                attributes.to_glib_none().0,
                priority,
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_right_margin_position")]
    fn set_right_margin_position(&self, pos: u32) {
        unsafe {
            ffi::gtk_source_view_set_right_margin_position(self.as_ref().to_glib_none().0, pos);
        }
    }

    #[doc(alias = "gtk_source_view_set_show_line_marks")]
    fn set_show_line_marks(&self, show: bool) {
        unsafe {
            ffi::gtk_source_view_set_show_line_marks(
                self.as_ref().to_glib_none().0,
                show.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_show_line_numbers")]
    fn set_show_line_numbers(&self, show: bool) {
        unsafe {
            ffi::gtk_source_view_set_show_line_numbers(
                self.as_ref().to_glib_none().0,
                show.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_show_right_margin")]
    fn set_show_right_margin(&self, show: bool) {
        unsafe {
            ffi::gtk_source_view_set_show_right_margin(
                self.as_ref().to_glib_none().0,
                show.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_smart_backspace")]
    fn set_smart_backspace(&self, smart_backspace: bool) {
        unsafe {
            ffi::gtk_source_view_set_smart_backspace(
                self.as_ref().to_glib_none().0,
                smart_backspace.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_smart_home_end")]
    fn set_smart_home_end(&self, smart_home_end: SmartHomeEndType) {
        unsafe {
            ffi::gtk_source_view_set_smart_home_end(
                self.as_ref().to_glib_none().0,
                smart_home_end.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_view_set_tab_width")]
    fn set_tab_width(&self, width: u32) {
        unsafe {
            ffi::gtk_source_view_set_tab_width(self.as_ref().to_glib_none().0, width);
        }
    }

    #[doc(alias = "gtk_source_view_unindent_lines")]
    fn unindent_lines(&self, start: &mut gtk::TextIter, end: &mut gtk::TextIter) {
        unsafe {
            ffi::gtk_source_view_unindent_lines(
                self.as_ref().to_glib_none().0,
                start.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            );
        }
    }

    #[doc(alias = "change-case")]
    fn connect_change_case<F: Fn(&Self, ChangeCaseType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn change_case_trampoline<
            P: IsA<View>,
            F: Fn(&P, ChangeCaseType) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            case_type: ffi::GtkSourceChangeCaseType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                View::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(case_type),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"change-case\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    change_case_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_change_case(&self, case_type: ChangeCaseType) {
        self.emit_by_name::<()>("change-case", &[&case_type]);
    }

    #[doc(alias = "change-number")]
    fn connect_change_number<F: Fn(&Self, i32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn change_number_trampoline<P: IsA<View>, F: Fn(&P, i32) + 'static>(
            this: *mut ffi::GtkSourceView,
            count: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref(), count)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"change-number\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    change_number_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_change_number(&self, count: i32) {
        self.emit_by_name::<()>("change-number", &[&count]);
    }

    #[doc(alias = "join-lines")]
    fn connect_join_lines<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn join_lines_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"join-lines\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    join_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_join_lines(&self) {
        self.emit_by_name::<()>("join-lines", &[]);
    }

    #[doc(alias = "line-mark-activated")]
    fn connect_line_mark_activated<
        F: Fn(&Self, &gtk::TextIter, u32, gdk::ModifierType, i32) + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn line_mark_activated_trampoline<
            P: IsA<View>,
            F: Fn(&P, &gtk::TextIter, u32, gdk::ModifierType, i32) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            iter: *mut gtk::ffi::GtkTextIter,
            button: libc::c_uint,
            state: gdk::ffi::GdkModifierType,
            n_presses: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                View::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(iter),
                button,
                from_glib(state),
                n_presses,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"line-mark-activated\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    line_mark_activated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "move-lines")]
    fn connect_move_lines<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn move_lines_trampoline<P: IsA<View>, F: Fn(&P, bool) + 'static>(
            this: *mut ffi::GtkSourceView,
            down: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                View::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(down),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-lines\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    move_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_lines(&self, down: bool) {
        self.emit_by_name::<()>("move-lines", &[&down]);
    }

    #[doc(alias = "move-to-matching-bracket")]
    fn connect_move_to_matching_bracket<F: Fn(&Self, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_to_matching_bracket_trampoline<
            P: IsA<View>,
            F: Fn(&P, bool) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            extend_selection: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                View::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(extend_selection),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-to-matching-bracket\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    move_to_matching_bracket_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_to_matching_bracket(&self, extend_selection: bool) {
        self.emit_by_name::<()>("move-to-matching-bracket", &[&extend_selection]);
    }

    #[doc(alias = "move-words")]
    fn connect_move_words<F: Fn(&Self, i32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn move_words_trampoline<P: IsA<View>, F: Fn(&P, i32) + 'static>(
            this: *mut ffi::GtkSourceView,
            count: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref(), count)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-words\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    move_words_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_words(&self, count: i32) {
        self.emit_by_name::<()>("move-words", &[&count]);
    }

    //#[doc(alias = "push-snippet")]
    //fn connect_push_snippet<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    InOut location: Gtk.TextIter
    //}

    #[doc(alias = "show-completion")]
    fn connect_show_completion<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn show_completion_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"show-completion\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    show_completion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_show_completion(&self) {
        self.emit_by_name::<()>("show-completion", &[]);
    }

    #[doc(alias = "smart-home-end")]
    fn connect_smart_home_end<F: Fn(&Self, &gtk::TextIter, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn smart_home_end_trampoline<
            P: IsA<View>,
            F: Fn(&P, &gtk::TextIter, i32) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            iter: *mut gtk::ffi::GtkTextIter,
            count: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                View::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(iter),
                count,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"smart-home-end\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    smart_home_end_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "auto-indent")]
    fn connect_auto_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_auto_indent_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::auto-indent\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_auto_indent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "background-pattern")]
    fn connect_background_pattern_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_pattern_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-pattern\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_background_pattern_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "completion")]
    fn connect_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_completion_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::completion\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_completion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-snippets")]
    fn connect_enable_snippets_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_snippets_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-snippets\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_snippets_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "highlight-current-line")]
    fn connect_highlight_current_line_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_highlight_current_line_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::highlight-current-line\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_highlight_current_line_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "indent-on-tab")]
    fn connect_indent_on_tab_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_on_tab_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent-on-tab\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_indent_on_tab_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "indent-width")]
    fn connect_indent_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_width_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent-width\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_indent_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "indenter")]
    fn connect_indenter_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indenter_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indenter\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_indenter_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "insert-spaces-instead-of-tabs")]
    fn connect_insert_spaces_instead_of_tabs_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_insert_spaces_instead_of_tabs_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::insert-spaces-instead-of-tabs\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_insert_spaces_instead_of_tabs_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "right-margin-position")]
    fn connect_right_margin_position_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_right_margin_position_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::right-margin-position\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_right_margin_position_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-line-marks")]
    fn connect_show_line_marks_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_line_marks_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-line-marks\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_show_line_marks_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-line-numbers")]
    fn connect_show_line_numbers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_line_numbers_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-line-numbers\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_show_line_numbers_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-right-margin")]
    fn connect_show_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_right_margin_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-right-margin\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_show_right_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "smart-backspace")]
    fn connect_smart_backspace_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_smart_backspace_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::smart-backspace\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_smart_backspace_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "smart-home-end")]
    fn connect_smart_home_end_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_smart_home_end_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::smart-home-end\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_smart_home_end_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "space-drawer")]
    fn connect_space_drawer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_space_drawer_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::space-drawer\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_space_drawer_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tab-width")]
    fn connect_tab_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tab_width_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tab-width\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_tab_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<View>> ViewExt for O {}
