/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file Module.h
    \author Romain BONDUE
    \date 18/08/2005 */
#ifndef __MODULE_H__
#define __MODULE_H__

#include <stdexcept>
#include <vector>

extern "C"{
#include <gtk/gtk.h>
}

#include "Parameters.h"
#include "Exceptions.h"



namespace nsWireless
{
    class IDriver;
    class CCell;
    class CDeviceInfo;
    class CMacAddress;

} // namespace nsWireless



namespace nsUserData{class CProfile;}



namespace nsGUI{class CGtkGUI;}



namespace nsCore
{
    class ICLIModule
    {
      public :
        virtual ~ICLIModule () throw() {}
        virtual const nsUserData::CProfile& GetProfile (unsigned) const
                                                                    throw() = 0;
        virtual void ApplyProfile (unsigned) throw (nsErrors::CSystemExc) = 0;
        virtual unsigned GetNbProfile () const throw() = 0;
        virtual nsWireless::IDriver& GetDriver () throw() = 0;
        virtual const nsWireless::IDriver& GetDriver () const throw() = 0;

    }; // ICLIModule


    class IModule
    {
      public :
        virtual ~IModule () throw() {}
        virtual nsWireless::IDriver& GetDriver () throw() = 0;
        virtual const nsWireless::IDriver& GetDriver () const throw() = 0;
        virtual nsUserData::CProfile* NewProfile (::GtkWindow*) throw() = 0;
        virtual nsUserData::CProfile* NewProfile
                          (::GtkWindow*, const nsWireless::CCell&) throw() = 0;
        virtual bool EditProfile (::GtkWindow*, unsigned) throw() = 0;
        virtual void DeleteProfile (unsigned) throw() = 0;
        virtual void ApplyProfile (unsigned) throw (nsErrors::CSystemExc) = 0;
        virtual void ApplyProfile (unsigned, const nsWireless::CMacAddress&)
                                            throw (nsErrors::CSystemExc) = 0;
        virtual nsUserData::CProfile& GetProfile (unsigned) throw() = 0;
        virtual unsigned GetNbProfile () const throw() = 0;
        virtual void RecordProfiles () throw (nsErrors::CException) = 0;
        /** \return A GUI component to set driver specific parameters (may
         *          return 0 if none). */
        virtual ::GtkWidget* GetPrivateTab () throw() = 0;
        virtual void BecomeRoot ()
                            throw (nsErrors::CException, std::bad_alloc) = 0;

    }; // IModule


    void GetWirelessDevice (std::vector<nsWireless::CDeviceInfo>&)
                                                throw (nsErrors::CException);


    bool IsSupported (const nsWireless::CDeviceInfo&) throw();


    IModule* MakeModule (const nsWireless::CDeviceInfo&, nsGUI::CGtkGUI*)
                                throw (nsErrors::CException, std::bad_alloc);


    ICLIModule* MakeCLIModule (const nsWireless::CDeviceInfo&)
                                throw (nsErrors::CException, std::bad_alloc);

} // namespace nsCore

#endif // __MODULE_H__
