/*
 * s51dude - A Downloader/Uploader for 8051 device programmers
 * Copyright (C) 2008 Lucas Chiesa.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef	_parts_h_
#define	_parts_h_
#include <stdio.h>
#include <sys/unistd.h>

//Tiempos de Delay
#define			TAMANIO_MASK		0x07
#define			TAMANIO_AVR			0x04
#define			TAMANIO_8253		0x04
#define			TAMANIO_8252		0x03

#define			MICRO_S51_MASK		0x38
#define			MICRO_AVR			0x00
#define			MICRO_8253			0x08
#define			MICRO_8252			0x10

#define			INVERTED_SCK_MASK	0x40
#define			AVR_SCK				0x00

#ifdef WIN32
#include <windows.h>
#define sleep(seconds) Sleep(seconds * 1000) /* from mingw.org list */
#define usleep(useconds) Sleep(useconds / 1000)
//El de windows:
//Sleep (1000) Espera 1 segundo
//Sleep (10000) Espera 10 segundo

//El de linux:
//sleep (1)  Espera 1 segundo
//sleep (10) Espera 10 segundos
//usleep (1000) Espera 1ms
//usleep (1) Espera 1us
#endif

// Prototipos de las funciones que graban y leen lock bits.
void wlb_s52 (int lb1, int lb2, int lb3);
void wlb_s8253 (int lb1, int lb2, int lb3);
void wlb_s8252 (int lb1, int lb2, int lb3);
void rlb_s52 (void);
void rlb_s8253 (void);

static micro_t s52 = {
	.mem_micro = 8192, //8k
	.mem_eeprom = 0, //no tiene
	.val = TAMANIO_8253 + MICRO_8253,
	.max_chunk = 4,
	.ind_r_eeprom = 0x20,
	.ind_w_eeprom = 0x20,
	.ind_r_flash = 0x20,
	.ind_w_flash = 0x40 + (0x20 << 8),
	.enable_programing = {0xAC, 0x53, 0x00, 0x00},
	.erase = {0xAC, 0x80, 0x00, 0x00},
	.delay = 6000,
	.protocol = PROTOCOL_SPI_S8253,
	.text_micro = "s52",
	.write_lockbits = &wlb_s52,
	.read_lockbits = &rlb_s52,
};

static micro_t s8253 = {
	.mem_micro = 12288, //12k
	.mem_eeprom = 2048, //2k
	.val = TAMANIO_8253 + MICRO_8253 + INVERTED_SCK_MASK,
	.max_chunk = 32,
	.ind_r_eeprom = 0xA0,
	.ind_w_eeprom = 0xC0 + (0xA0 << 8),
	.ind_r_flash = 0x20,
	.ind_w_flash = 0x40 + (0x20 << 8),
	.enable_programing = {0xAC, 0x53, 0x00, 0x00},
	.erase = {0xAC, 0x80, 0x00, 0x00},
	.delay = 5000,
	.protocol = PROTOCOL_SPI_S8253,
	.text_micro = "s8253",
	.write_lockbits = &wlb_s8253,
	.read_lockbits = &rlb_s8253,
};

static micro_t s8252 = {
	.mem_micro = 8192, //8k
	.mem_eeprom = 2048, //2k
	.val = TAMANIO_8252 + MICRO_8252,
	.max_chunk = 128,
	.ind_r_eeprom = 0x06,
	.ind_w_eeprom = 0x05 + (0x06 << 8),
	.ind_r_flash = 0x01,
	.ind_w_flash = 0x02 + (0x01 << 8),
	.enable_programing = {0x00, 0xAC, 0x53, 0x00},
	.erase = {0x00, 0xAC, 0x04, 0x00},
	.delay = 6000,
	.protocol = PROTOCOL_SPI_S8253,
	.text_micro = "s8252",
	.write_lockbits = &wlb_s8252,
	.read_lockbits = NULL,
};

static micro_t s53 = {
	.mem_micro = 12288, //12k
	.mem_eeprom = 0, //no tiene
	.val = TAMANIO_8253 + MICRO_8253,
	.max_chunk = 128,
	.ind_r_eeprom = 0x20,
	.ind_w_eeprom = 0x02,
	.ind_r_flash = 0x01,
	.ind_w_flash = 0x02 + (0x01 << 8),
	.delay = 1000,
	.protocol = PROTOCOL_SPI_S8253,
	.enable_programing = {0x00, 0xAC, 0x53, 0x00},
	.erase = {0x00, 0xAC, 0x04, 0x00},
	.text_micro = "s53",
	.write_lockbits = &wlb_s8252,
	.read_lockbits = NULL,
};

static micro_t *target_list[] = { &s52, &s8253, &s8252, &s53 };
int cant_micros = 4;

#endif
