#!/bin/bash
# bbou@ac-toulouse.fr
# 28/08/2009  
# _install-pam-core.sh

### P A R A M S

MYVERBOSE=
if [ "$1" == "-v" ];then
	export MYVERBOSE="True"
	shift
fi
if [ "$1" == "-t" ];then
	MYTEST="True"
	shift
else
	MYTEST=
fi
if [ "$1" == "-w" ];then
	MYDOWINBIND="True"
	shift
else
	MYDOWINBIND=
fi
if [ "$1" == "-h" ];then
	MYDOMKHOMEDIR="True"
	shift
else
	MYDOMKHOMEDIR=
fi
if [ "$1" == "-m" ];then
	MYDOMOUNT="True"
	shift
else
	MYDOMOUNT=
fi
MYSERVER="$1"
MYSHARE="$2"
MYMOUNTPOINT="$3"
MYDOMAIN="$4"
MYUSER="$5"
#echo "test ${MYTEST}"
#echo "verbose ${MYVERBOSE}"
#echo "install pam_winbind ${MYDOWINBIND}"
#echo "install pam_mkhomedir ${MYDOMKHOMEDIR}"
#echo "install pam_mount ${MYDOMOUNT}"
#echo "server=${MYSERVER}"
#echo "share=${MYSHARE}"
#echo "domain=${MYDOMAIN}"
#echo "user=${MYUSER}"
#echo "mountpoint=${MYMOUNTPOINT}"

### M O D I F I E D   F I L E S ...

# ${PAMDIR}/${PAMSERVICES} 

### ... W I T H   A C C E S S

INST_UID=root
INST_GID=root
INST_PAM_MOD=644

### I N C L U D E

. ./_include.sh

### O T H E R

services=${PAMSERVICES}
modes=${PAMMODES}
pamdetecttarget="login"
pamdetectsource=`echo "${services}" | awk '{print $1}'`
case ${DISTRIBUTION} in
	Redhat|Fedora|Mandriva)
		# pam_stack facility
		pamdetectmatch="(pam_stack.so[[:space:]]*service=system-auth|include[[:space:]]*system-auth)"
		pamauthupdate=
		;;
	Suse)
		# include facility
		pamdetectmatch="(auth|account|password|session)[[:space:]]*include[[:space:]]*common-(auth|account|password|session)"
		pamauthupdate=
		;;
	Debian|Ubuntu)
		# include facility
		pamdetectmatch="@include[[:space:]]${pamdetectsource}"
		pamauthupdate=True
		;;
	*)
		echo "Unsupported distribution" >&2
		exit 1
esac
#echo "services=${services}"
#echo "modes=${modes}"
#echo "pamauthupdate=${pamauthupdate}"

### S T A R T

# D I R
savedir=${TMPDIR}/pam.d.`date '+%Y%m%d%H%M%S'`
[ -d  ${savedir} ] || mkdir ${savedir}
tmpdir=${TMPDIR}/pam.d
[ -d  ${tmpdir} ] || mkdir ${tmpdir}

# C H E C K
./_check-pam_mount.sh
if [ ! $? = 0 ]; then
	echo "![FAIL] pam_mount check failed"
	exit 1
fi

echo "+INSTALL"

# C O N F I G U R E  P A M _ M O U N T
pushd conf > /dev/null
./config-pam_mountconf.sh "${MYSERVER}" "${MYSHARE}" "${MYMOUNTPOINT}" "${MYDOMAIN}" "${MYUSER}"
./config-netlink.sh "${MYMOUNTPOINT}" "${MYSHARE}"
popd > /dev/null

# C O N F I G U R E  P A M
pushd conf > /dev/null

# check services
for i in ${services}; do
	if [ ! -f ${PAMDIR}/${i} ]; then
		echo "${PAMDIR}/${i} does not exist" >&2
		exit 1
	fi
done

# check reference to common auth file
if ! egrep "${pamdetectmatch}" ${PAMDIR}/${pamdetecttarget} > /dev/null; then
	echo "improper ${PAMDIR}/${pamdetecttarget}" >&2
	exit 2
fi

# save all services
echo "+save ${services} samba in ${PAMDIR} to ${savedir}"
pushd ${PAMDIR} > /dev/null
cp ${services} samba ${savedir}/
popd > /dev/null

# copy all services
echo "+copy ${services} samba in ${PAMDIR} to ${tmpdir}"
pushd ${PAMDIR} > /dev/null
cp ${services} samba ${tmpdir}/
popd > /dev/null

# do it
if [ "${MYDOWINBIND}" == "True" ]; then
./config-pam_winbind.sh -f ${tmpdir} "${services}" "${modes}"
fi
if [ "${MYDOMKHOMEDIR}" == "True" ]; then
./config-pam_mkhomedir.sh -f ${tmpdir} "${services}" "${modes}"
fi
sambaservice=
if [ "${MYDOMOUNT}" == "True" ]; then
sambaservice=samba
./config-pam_samba.sh -f ${tmpdir} ${tmpdir} "${services}"
./config-pam_mount.sh -f ${tmpdir} "${services}" "${modes}"
fi

# hook to debconf
./config-pam.sh

# bug fix
./config-bugfix-pam.sh

# install or display
pushd ${tmpdir} > /dev/null
if [ ! -z "${MYTEST}" ]; then
	# display
	if [ ! -z "${MYVERBOSE}" ];then
		for i in ${services} ${sambaservice}; do
			echo "----------------------------------------------------------------------"
			echo "#${i} (not effective on system)"
			echo ""
			cat ${i} | grep -v "^#" | grep -v "^$"
			echo "${i} not effective on system" >&2
		done
		for i in ${services}  ${sambaservice}; do
			echo "----------------------------------------------------------------------"
			echo "#diff ${PAMDIR}/${i} ${tmpdir}/${i}"
			echo ""
			diff ${PAMDIR}/${i} ${tmpdir}/${i}
		done
	fi
	echo "----------------------------------------------------------------------"
	popd > /dev/null
	popd > /dev/null
else
	# P R I V I L E G E
	if [ "$(whoami)" != "root" ]; then
		echo "User is $(whoami)"
		echo "This must be run as root" >&2
		exit 1
	fi

	# S T A T U S
	[ -d /var/lib/sadms ] || mkdir -p /var/lib/sadms
	echo '0' > /var/lib/sadms/pam
	
	# install
	if [ ! -z "${pamauthupdate}" ]; then
		services=
	fi
	for i in ${services}  ${sambaservice}; do
		echo "+install modified ${tmpdir}/${i} to ${PAMDIR}"
		${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_PAM_MOD} ${i} ${PAMDIR}/ > /dev/null
	done

	popd > /dev/null
	popd > /dev/null
	
	# refresh
	./_refresh-pam.sh	

	# S T A T U S
	echo '1' > /var/lib/sadms/pam
fi
