#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:34:08 
# _list-users.sh

### P A R A M S

MYVERBOSE=
if [ "$1" == "-v" ];then
	export MYVERBOSE="True"
	shift
fi
MYFILTER="$1"
MYNOTFILTER="$2"
#echo "filter=${MYFILTER}"
#echo "notfilter=${MYFILTER}"

### S T A R T

do_it(){
	# 1=id 2=uid 3=gid 4=home
	echo "$1 ($2)($3) $4"
}

echo "--------------------------------------------------------------------------------"
echo "LIST OF USERS"
echo "condition : ${MYFILTER}"
echo "not condition : ${MYNOTFILTER}"
echo "id (uid)(gid) home"
echo "--------------------------------------------------------------------------------"

if [ "${MYFILTER}" == "" ];then
	MYFILTER="1"
fi
if [ "${MYNOTFILTER}" == "" ];then
	MYNOTFILTER="0"
fi

ids=`getent passwd | awk 'BEGIN{FS=":"}{if('"${MYFILTER}"' && !'"${MYNOTFILTER}"') printf "%s:%s:%s:%s#",$1,$3,$4,$6}' | sort`
IFS="#"
for i in ${ids}; do
	id=`echo ${i} | sed 's/\([^:]*\):.*$/\1/'`
	uid=`echo ${i} | sed 's/[^:]*:\([^:]*\):.*$/\1/'`
	gid=`echo ${i} | sed 's/[^:]*:[^:]*:\([^:]*\):.*$/\1/'`
	home=`echo ${i} | sed 's/[^:]*:[^:]*:[^:]*:\([^:]*\)$/\1/'`

	#echo "${id}"
	#echo "${uid}"
	#echo "${gid}"
	#echo "${home}"

	if [ -z "${uid}" ]; then
		continue
	fi
	if [ -z "${gid}" ]; then
		continue
	fi
	if [ "${uid}" -lt 500 ]; then
		continue
	fi
	if [ "${uid}" -eq 65534 ]; then
		continue
	fi
	#if [ ! ${home} = "/home/${id}" ]; then
	#	continue
	#fi
	
	do_it ${id} ${uid} ${gid} ${home}
done

if [ ! -z "${MYVERBOSE}" ]; then

echo "--------------------------------------------------------------------------------"
ids=`getent passwd | sort | awk 'BEGIN{FS=":"}{if('"${MYFILTER}"' && !'"${MYNOTFILTER}"') printf "%s#",$1}'`
IFS="#"
for u in ${ids}; do
	echo -n "${u} is ";
	if ! id ${u} 2> /dev/null; then
		echo "<error>"
	fi
done

echo "--------------------------------------------------------------------------------"
ids=`getent passwd | sort | awk 'BEGIN{FS=":"}{if('"${MYFILTER}"' && !'"${MYNOTFILTER}"') printf "%s#",$1}'`
IFS="#"
for u in ${ids}; do
	python -c "import pwd; print pwd.getpwnam(\"${u}\");" 2> /dev/null;
done

fi

IFS="\t\n "
