package provide DS9 1.0

######
# Begin autogenerated taccle (version 1.3) routines.
# Although taccle itself is protected by the GNU Public License (GPL)
# all user-supplied functions are protected by their respective
# author's license.  See http://mini.net/tcl/taccle for other details.
######

namespace eval fits {
    variable yylval {}
    variable table
    variable rules
    variable token {}
    variable yycnt 0
    variable yyerr 0
    variable save_state 0

    namespace export yylex
}

proc fits::YYABORT {} {
    return -code return 1
}

proc fits::YYACCEPT {} {
    return -code return 0
}

proc fits::YYERROR {} {
    variable yyerr
    set yyerr 1
}

proc fits::yyclearin {} {
    variable token
    variable yycnt
    set token {}
    incr yycnt -1
}

proc fits::yyerror {s} {
    puts stderr $s
}

proc fits::setupvalues {stack pointer numsyms} {
    upvar 1 1 y
    set y {}
    for {set i 1} {$i <= $numsyms} {incr i} {
        upvar 1 $i y
        set y [lindex $stack $pointer]
        incr pointer
    }
}

proc fits::unsetupvalues {numsyms} {
    for {set i 1} {$i <= $numsyms} {incr i} {
        upvar 1 $i y
        unset y
    }
}

array set fits::table {
  0:257 reduce
  0:258 reduce
  0:260 reduce
  0:259 shift
  5:0,target 7
  9:0 reduce
  0:261 goto
  6:260,target 9
  11:0 reduce
  0:262 goto
  4:257 shift
  4:258 shift
  0:264 goto
  1:260,target 9
  4:260 shift
  6:257 shift
  7:263,target 11
  6:260 shift
  4:263 goto
  6:263 goto
  6:0,target 6
  2:0 accept
  1:258,target 9
  6:0 reduce
  6:257,target 5
  0:264,target 4
  4:260,target 7
  7:0,target 6
  1:257,target 9
  12:0 reduce
  0:0,target 8
  10:0,target 3
  4:258,target 6
  9:257,target 5
  8:0,target 2
  3:0 reduce
  1:0,target 9
  11:0,target 4
  0:262,target 3
  4:257,target 5
  7:0 reduce
  1:257 reduce
  1:258 reduce
  1:260 reduce
  9:0,target 6
  0:261,target 2
  7:257 shift
  2:0,target 0
  12:0,target 5
  9:257 shift
  7:257,target 5
  0:0 reduce
  7:263 goto
  0:260,target 8
  0:259,target 1
  9:263 goto
  4:0 reduce
  6:263,target 10
  3:0,target 1
  8:0 reduce
  10:0 reduce
  0:258,target 8
  9:263,target 12
  4:0,target 6
  0:257,target 8
  1:0 reduce
  4:263,target 8
  5:0 reduce
}

array set fits::rules {
  9,l 264
  2,l 262
  6,l 263
  3,l 262
  7,l 263
  0,l 265
  4,l 262
  8,l 264
  1,l 261
  5,l 262
}

array set fits::rules {
  5,dc 4
  0,dc 1
  8,dc 0
  3,dc 3
  6,dc 0
  1,dc 1
  9,dc 1
  4,dc 3
  7,dc 1
  2,dc 2
}

array set fits::rules {
  7,line 29
  4,line 24
  1,line 19
  9,line 33
  6,line 28
  3,line 23
  8,line 32
  5,line 25
  2,line 22
}

array set fits::lr1_table {
  0 {{0 0 0} {1 0 0} {2 0 0} {3 0 0} {4 0 0} {5 0 0} {8 {0 257 258 260} 0} {9 {0 257 258 260} 0}}
  1 {{9 {0 257 258 260} 1}}
  2 {{0 0 1}}
  3 {{1 0 1}}
  4 {{2 0 1} {3 0 1} {4 0 1} {5 0 1} {6 0 0} {7 0 0}}
  0,trans {{259 1} {261 2} {262 3} {264 4}}
  1,trans {}
  5 {{7 0 1}}
  2,trans {}
  6 {{3 0 2} {5 0 2} {6 0 0} {7 0 0}}
  3,trans {}
  7 {{4 0 2} {6 0 0} {7 0 0}}
  4,trans {{257 5} {258 6} {260 7} {263 8}}
  8 {{2 0 2}}
  10 {{3 0 3}}
  9 {{5 0 3} {6 0 0} {7 0 0}}
  5,trans {}
  11 {{4 0 3}}
  6,trans {{257 5} {260 9} {263 10}}
  12 {{5 0 4}}
  7,trans {{257 5} {263 11}}
  8,trans {}
  10,trans {}
  9,trans {{257 5} {263 12}}
  11,trans {}
  12,trans {}
}

array set fits::token_id_table {
  264,line 31
  262,title {}
  0,t 0
  0 {$}
  263,title {}
  264,title {}
  error,t 0
  error error
  265,title {}
  258,line 11
  261,line 18
  error,line 16
  257 STRING_
  257,t 0
  263,line 27
  258 MASK_
  258,t 0
  error,title {}
  260,t 0
  260 SLICE_
  259 NEW_
  259,t 0
  265,line 34
  261,t 1
  261 command
  262,t 1
  262 fits
  257,line 7
  263,t 1
  263 filename
  264,t 1
  264 new
  260,line 13
  257,title string
  259,line 12
  265,t 1
  265 start'
  258,title MASK
  262,line 21
  260,title SLICE
  259,title NEW
  261,title {}
}

proc fits::yyparse {} {
    variable yylval
    variable table
    variable rules
    variable token
    variable yycnt
    variable lr1_table
    variable token_id_table
    variable yyerr
    variable save_state

    set yycnt 0
    set state_stack {0}
    set value_stack {{}}
    set token ""
    set accepted 0
    set yyerr 0
    set save_state 0

    while {$accepted == 0} {
        set state [lindex $state_stack end]
        if {$token == ""} {
            set yylval ""
            set token [yylex]
            set buflval $yylval
	    if {$token>0} {
	        incr yycnt
            }
        }
        if {![info exists table($state:$token)] || $yyerr} {
	    if {!$yyerr} {
	        set save_state $state
	    }
            # pop off states until error token accepted
            while {[llength $state_stack] > 0 && \
                       ![info exists table($state:error)]} {
                set state_stack [lrange $state_stack 0 end-1]
                set value_stack [lrange $value_stack 0 \
                                       [expr {[llength $state_stack] - 1}]]
                set state [lindex $state_stack end]
            }
            if {[llength $state_stack] == 0} {
 
	        set rr { }
                if {[info exists lr1_table($save_state,trans)] && [llength $lr1_table($save_state,trans)] >= 1} {
                    foreach trans $lr1_table($save_state,trans) {
                        foreach {tok_id nextstate} $trans {
			    set ss $token_id_table($tok_id,title)
			    if {$ss != {}} {
			        append rr "$ss, "
                            }
                        }
                    }
                }
		set rr [string trimleft $rr { }]
		set rr [string trimright $rr {, }]
                yyerror "parse error, expecting: $rr"


                return 1
            }
            lappend state_stack [set state $table($state:error,target)]
            lappend value_stack {}
            # consume tokens until it finds an acceptable one
            while {![info exists table($state:$token)]} {
                if {$token == 0} {
                    yyerror "end of file while recovering from error"
                    return 1
                }
                set yylval {}
                set token [yylex]
                set buflval $yylval
            }
            continue
        }
        switch -- $table($state:$token) {
            shift {
                lappend state_stack $table($state:$token,target)
                lappend value_stack $buflval
                set token ""
            }
            reduce {
                set rule $table($state:$token,target)
                set ll $rules($rule,l)
                if {[info exists rules($rule,e)]} {
                    set dc $rules($rule,e)
                } else {
                    set dc $rules($rule,dc)
                }
                set stackpointer [expr {[llength $state_stack]-$dc}]
                setupvalues $value_stack $stackpointer $dc
                set _ $1
                set yylval [lindex $value_stack end]
                switch -- $rule {
                    2 { FitsCmdLoad $2 {} {} }
                    3 { FitsCmdLoad $3 mask {} }
                    4 { FitsCmdLoad $3 {} slice }
                    5 { FitsCmdLoad $4 mask slice }
                    6 { set _ {} }
                    7 { set _ $1 }
                    9 { CreateFrame }
                }
                unsetupvalues $dc
                # pop off tokens from the stack if normal rule
                if {![info exists rules($rule,e)]} {
                    incr stackpointer -1
                    set state_stack [lrange $state_stack 0 $stackpointer]
                    set value_stack [lrange $value_stack 0 $stackpointer]
                }
                # now do the goto transition
                lappend state_stack $table([lindex $state_stack end]:$ll,target)
                lappend value_stack $_
            }
            accept {
                set accepted 1
            }
            goto -
            default {
                puts stderr "Internal parser error: illegal command $table($state:$token)"
                return 2
            }
        }
    }
    return 0
}

######
# end autogenerated taccle functions
######

proc fits::yyerror {msg} {
     variable yycnt
     variable yy_current_buffer
     variable index_

     ParserError $msg $yycnt $yy_current_buffer $index_
}
