/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class OneJarFile
extends JarFile {
    protected final String jarFilename;
    protected final String filename;
    protected final JarEntry wrappedJarFile;

    public OneJarFile(String myJarPath, String jarFilename, String filename) throws IOException {
        super(myJarPath);
        this.jarFilename = jarFilename;
        this.filename = filename;
        this.wrappedJarFile = super.getJarEntry(this.jarFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JarEntry getJarEntry(String name) {
        String filename = name.substring(name.indexOf("!/") + 2);
        if (filename.equals("META-INF/MANIFEST.MF")) {
            return new JarEntry(filename){};
        }
        try {
            JarInputStream is = new JarInputStream(super.getInputStream(this.wrappedJarFile));
            try {
                JarEntry entry;
                do {
                    if ((entry = is.getNextJarEntry()) == null) return null;
                } while (!entry.getName().equals(filename));
                JarEntry jarEntry = entry;
                return jarEntry;
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Undefined Error", e);
        }
    }

    public Enumeration entries() {
        try {
            final JarInputStream is = new JarInputStream(super.getInputStream(this.wrappedJarFile));
            return new Enumeration(){
                protected JarEntry next;

                public Object nextElement() {
                    if (this.next != null) {
                        JarEntry tmp = this.next;
                        this.next = null;
                        return tmp;
                    }
                    try {
                        return is.getNextJarEntry();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Undefined Error", e);
                    }
                }

                public boolean hasMoreElements() {
                    if (this.next != null) {
                        return true;
                    }
                    try {
                        this.next = is.getNextJarEntry();
                        if (this.next == null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Undefined Error", e);
                    }
                    return this.next != null;
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException("Undefined Error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized InputStream getInputStream(ZipEntry ze) throws IOException {
        if (ze == null) {
            return null;
        }
        try {
            JarInputStream is = new JarInputStream(super.getInputStream(this.wrappedJarFile));
            if (this.filename.equals("META-INF/MANIFEST.MF")) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                is.getManifest().write(baos);
                return new ByteArrayInputStream(baos.toByteArray());
            }
            try {
                JarEntry entry;
                do {
                    if ((entry = is.getNextJarEntry()) == null) throw new RuntimeException("Entry not found : " + ze.getName());
                } while (!entry.getName().equals(ze.getName()));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.copy(is, baos);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                return byteArrayInputStream;
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Undefined Error", e);
        }
    }

    protected void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }
}

