"""
Tests for generation scripts.
"""

from zope.annotation.interfaces import IAnnotatable
from zope.app.dependable.interfaces import IDependable
from zope.app.dependable import Dependable
from zope.app.testing.setup import setUpAnnotations
from zope.component import provideAdapter

from schooltool.basicperson.interfaces import IBasicPerson
from schooltool.contact.basicperson import getBoundContact
from schooltool.contact.basicperson import getPersonOfBoundContact
from schooltool.contact.contact import Contactable
from schooltool.relationship.annotatable import getRelationshipLinks
from schooltool.relationship.interfaces import IRelationshipLinks


def provideAdapters():
    setUpAnnotations()
    provideAdapter(getRelationshipLinks, adapts=(IAnnotatable,),
                   provides=IRelationshipLinks)
    provideAdapter(getBoundContact, adapts=(IBasicPerson,))
    provideAdapter(Contactable, adapts=(IBasicPerson,))
    provideAdapter(getPersonOfBoundContact)
    provideAdapter(Dependable, adapts=(IAnnotatable,),
                   provides=IDependable)

