# Release Notes v0.3.0 : OpenPSA Model Exchange Format Support
This release introduces a refactored structure of the core code and support for XML input files.


## Major Changes

- XML input files formatted according to OpenPSA Model Exchange Format
    * RelaxNG validation of input files.
- Refactored code structure conceptually similar to the structure of the XML tree from the input file.
- Three entities: Gates, Basic events, House events.
- Performance optimization of the tree expansion (around 1.5x faster) and MCS generation (around 3x faster)
- Cut-off probability for cut sets is introduced for faster probability calculations (around 40-50x faster)
- Gates can be easily re-used without creating TransferIn/Out input files
- The fault tree generator script outputs XML input file


## Deprecated Features

- The previous custom input formats for a fault tree and event probabilities
- L-model probability description with failure rates (This will be implemented by more broad expressions in future)
- TransferIn and TransferOut are not gate-like types but symbols to represent the re-use of gates.
- Undeveloped/Conditional event will be treated just like a basic event with an additional description.


## Since v0.2.0

- 131 commits resulted in 305 files changed 15863 insertions and 22968 deletions.
