#include "ideal_defden.h"

double IdealDefdenGenerator::defden(V3 pos,CEnvironment &belo, QList<Matrix> &mi){
  double rho=0.0;
  double argu;
  for (int i=0; i<belo.size(); i++){
    //V3 frac = V3(fmod(9999.+belo.at(i).frac.x,1.0), fmod(9999.+belo.at(i).frac.y,1.0), fmod(9999.+belo.at(i).frac.z,1.0));
    V3 pos0 = pos - belo.at(i).frac;
    argu = pos0 * (mi.at(i) * pos0);
    if (argu>-37.0)// this speeds it up!
        rho += belo.at(i).sof_org * exp(argu);
  }
  return rho;
}

void IdealDefdenGenerator::beloWriteCube(){
  if (!chgl->hideBeLo->isVisible()) {qDebug()<<"BeLo: 'rrrrrrr!'"; return; }
  CEnvironment belo,bu;
  uint stepx=chgl->mol->cell.a/0.12;
  uint stepy=chgl->mol->cell.b/0.12;
  uint stepz=chgl->mol->cell.c/0.12;
  size_t ntot = stepx * stepy * stepz;
  //size_t n6 = ntot*sizeof(double);
  float *dat=(float*) malloc(ntot*sizeof (float));
  //double capvx=1.0/ntot*chgl->mol->cell.V;
  V3 _dx=V3(1.0/stepx,0,0),_dy=V3(0,1.0/stepy,0),_dz=V3(0,0,1.0/stepz);
  V3 org = 0.5 * _dx + 0.5 * _dy + 0.5 * _dz;
  for (int bl=0; bl<chgl->mol->asymm.size(); bl++){
    if (chgl->mol->asymm.at(bl).an==-42){  
      bu.append(chgl->mol->asymm[bl]);
    }
  }
  belo = chgl->mol->packInLimits(bu,-0.1,1.1,-0.1,1.1,-0.1,1.1);
  emit message(QString("computing on %1 BEDE LONE objects.").arg(belo.size()));
  bu.clear();
  double midd=9.9e37,madd=-9.9e37,rho,summ=0.0,sum1=0.0, sum2=0.0;
  QList<Matrix> mi;
  //const double pisqrt=sqrt(M_PI);
  const double pi2=M_PI*M_PI;
  //const double pisqrt3=M_PI*pisqrt;
  Matrix M,Mi;
  double d;
  for (int i=0; i<belo.size(); i++){
    //M = (chgl->mol->cell.Gi* (belo.at(i).peakHeight*0.25));
    M = (chgl->mol->cell.Gi* ((belo.at(i).peakHeight*4.0))) + (belo.at(i).uf);//uf is Bij here
    Mi = inverse(M);
    //sof==a peakHeight=b
    d = determinant(Mi);
    belo[i].sof_org = sqrt(d) * belo.at(i).sof  / chgl->mol->cell.V;// * pisqrt3
    Mi = Mi *(-pi2);
    mi.append(Mi);
  } 
  uint pro=0,aproc,bproc=10;
  for (size_t iz=0; iz<stepz; iz++){
    for (size_t iy=0; iy<stepy; iy++){
      for (size_t ix=0; ix<stepx; ix++){
        rho=defden((ix*_dx)+(iy*_dy)+(iz*_dz)+org,belo,mi);//+minp
        midd=qMin(rho,midd);
        madd=qMax(rho,madd);
        if (rho>0.0) sum1+=rho;
        else sum2+=rho;
        summ+=rho;
        if (fabs(rho)<=1.0e-98) rho=0.0;
        dat[ix + iy*stepx + iz*stepx*stepy]=(float)rho;
        pro++;
      }
    }
    aproc=(pro*100)/ntot;
    if (aproc!=bproc){
        emit message(QString("Calulating deformation density %1% (steps:%2)").arg(aproc).arg(ntot));
        bproc=aproc;
    }
    //emit message(QString("Calulating deformation density %1%").arg(((iz/stepz) * 100)));
//    printf("#");fflush(stdout);

  }
  mi.clear();
  printf("%f %f %f \n",midd,madd,summ);
  bool gut = fxle->loadMap(stepx,stepy,stepz,dat);
  printf("%f %f %f %d\n",midd,madd,summ,gut);
  //printf("\n %g %g %g (%g  %g)\n",midd,madd,summ,ap,am);
  //  fclose(cfg);
  /*
  QString fileName = QString("%1/%2").arg(dirName.section('/',0,-2)).arg("/testBedeLone.raw");
  FILE *raw=fopen(fileName.toStdString().c_str(),"wb");
  struct BMhead{
    int h,sd,d,nn1,nn2,nn3;
    double cel[7];
    int f;
    int sid; 
  };

  BMhead bm;
  bm.h=bm.f=76;
  bm.sd=bm.d=3;
  bm.nn1=stepx;//nx
  bm.nn2=stepy;//ny
  bm.nn3=stepz;//nz
  bm.cel[0]=chgl->mol->cell.a;
  bm.cel[1]=chgl->mol->cell.b;
  bm.cel[2]=chgl->mol->cell.c;
  bm.cel[3]=chgl->mol->cell.al;
  bm.cel[4]=chgl->mol->cell.be;
  bm.cel[5]=chgl->mol->cell.ga;
  bm.cel[6]=chgl->mol->cell.V;
  fwrite((void*)&bm,sizeof(BMhead)-sizeof(int),1,raw);
  fwrite((void*)&n6,sizeof(int),1,raw);
  fwrite((void*)dat,n6,1,raw);
  fwrite((void*)&n6,sizeof(int),1,raw);
  fclose(raw);
  */
  fxle->dimc=QColor("darkorange");
  fxle->dipc=QColor("teal");
  emit message(QString("finished! minRho %1 e/A^3 %2 e/A^3 %3 e/A^3 %4 ").arg(midd).arg(madd).arg(summ).arg(gut));
}
