#version 150
/* std.frag -  simple fragment shader */

in vec3 Normal;
in vec3 uv;
in vec3 eye;
flat in int wall;
flat in vec3 flatNormal;

uniform float angle;
uniform vec4 Color;

out vec4 fragColor;
in vec3 _lightDirection;
const float cut =0.07;

// entry point
//
void main( void ){
        // pass through interpolated vertex color.
    bool open=true;
    bool ball=true;
    vec3 XYZ=abs(Normal);
    float NdotL = abs(dot((wall>0.1)?Normal:flatNormal, _lightDirection));
    vec4 color = Color * (vec4(0.4,0.4,0.4,1.0) + max(NdotL,0.0));
    if (wall>0.1){
        if(length(uv)>0.54) discard;
        else fragColor = color;
    }
    else {
        if ((min(XYZ.x,min(XYZ.y,XYZ.z))<=cut)){
        fragColor = mix(color, vec4(0.0,0.0,0.0,1.0), 0.6);
        } else
        if (open) {
        int ep=0,np=0;
        ep+=(eye.x>=0.0)?1:0;
        ep+=(eye.y>=0.0)?2:0;
        ep+=(eye.z>=0.0)?4:0;
        np+=(Normal.x>=0.0)?1:0;
        np+=(Normal.y>=0.0)?2:0;
        np+=(Normal.z>=0.0)?4:0;
        if (ep==np) discard;
        else {
            if (ball) fragColor = color;
            else discard;
        }
    }
    else
      if (ball) fragColor = color;
      else discard;
      //*/

}
}
