/*
 * VRT RULES
 *
 * Copyright (C) 2014-2019 Cisco and/or its affiliates. All rights reserved.
 * Copyright (C) 2005-2013 Sourcefire, Inc.
 *
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int ruleIGMPIPOPTDOSeval(void *p);

static HdrOptCheck ruleIGMPIPOPTDOShdr0 =
{
    IP_HDR_PROTO,
    CHECK_EQ,
    IPPROTO_IGMP,
    0,
    0
};

static RuleOption ruleIGMPIPOPTDOSoption0 =
{
    OPTION_TYPE_HDR_CHECK,
    { &ruleIGMPIPOPTDOShdr0 }
};

char evil[] = "|11|";

// content:"RNTO", nocase;
static ContentInfo ruleIGMPIPOPTDOScontent1 =
{
    (u_int8_t *) &evil, /* pattern (now in snort content format) */
    1, /* depth */
    0, /* offset */
    CONTENT_BUF_RAW, /* flags*/
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length */
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption ruleIGMPIPOPTDOSoption1 =
{
    OPTION_TYPE_CONTENT,
    { &ruleIGMPIPOPTDOScontent1 }
};

/* references for sid IGMPIPOPTDOS */
/* reference:url,www.microsoft.com/technet/security/bulletin/ms06-007.mspx"; */
static RuleReference ruleIGMPIPOPTDOSref1 =
{
    "url", /* type */
    "www.microsoft.com/technet/security/bulletin/ms06-007.mspx" /* value */
};

static RuleReference *ruleIGMPIPOPTDOSrefs[] =
{
    &ruleIGMPIPOPTDOSref1,
    NULL
};
RuleOption *ruleIGMPIPOPTDOSoptions[] =
{
    &ruleIGMPIPOPTDOSoption0,
    &ruleIGMPIPOPTDOSoption1,
    NULL
};

Rule ruleIGMPIPOPTDOS = {
   /* rule header, akin to => tcp any any -> any any               */
   {
       IPPROTO_IP, /* proto */
       "any", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "any", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   {
       3,  /* genid (HARDCODED!!!) */
       7020, /* sigid */
       1, /* revision */

       "attempted-dos", /* classification, generic */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "DOS IGMP IP Options validation attempt",     /* message */
       ruleIGMPIPOPTDOSrefs, /* ptr to references */
       NULL /* Meta data */
   },
   ruleIGMPIPOPTDOSoptions, /* ptr to rule options */
   &ruleIGMPIPOPTDOSeval, /* ptr to rule detection function */
   0, /* am I initialized yet? */
   0, /* number of options */
   0, /* don't alert */
   NULL /* ptr to internal data... setup during rule registration */
};


/* detection functions */
int ruleIGMPIPOPTDOSeval(void *p) {
    int i = 0;
    u_int8_t alert = 0;
    const u_int8_t *cursor_normal = 0;
    SFSnortPacket *sp = (SFSnortPacket *) p;
    //const u_int8_t *cursor_uri = 0;

    if (checkHdrOpt(p, ruleIGMPIPOPTDOSoptions[0]->option_u.hdrData)) {
        if (contentMatch(p, ruleIGMPIPOPTDOSoptions[1]->option_u.content, &cursor_normal) > 0) {

            if (sp->ip4_options_length >= 2) {
                if ( sp->ip4_options_data[0] == 0 &&
                     sp->ip4_options_data[1] == 0 ) {
                    return RULE_MATCH;
                }
            }

            for(i=0; i< (int) sp->num_ip_options; i++) {
                if (sp->ip_options[i].option_code == 148) {
                    return RULE_NOMATCH;
                }

                if (sp->ip_options[i].length == 1) {
                    alert++;
                }
            }
            if (alert > 0) {
                return RULE_MATCH;
            }
        }
    }
    return RULE_NOMATCH;
}

#if 0
Rule *rules[] = {
    &ruleIGMPIPOPTDOS,
    NULL
};
#endif
