5.2 Iteration und Schleifen

# Iteration und Schleifen

Bislang haben wir einige Zeit damit verbracht, uns unterschiedliche 
Klänge anzusehen, die Du mit `play` und `sample` erzeugen kannst. Wir 
haben auch gelernt, wie Du den Ablauf dieser Klänge mit `sleep` steuern 
kannst.

Wahrscheinlich hast Du entdeckt, dass man mit diesen Grundbausteinen 
schon *vieles* bauen kann. Eine ganz neue Dimension eröffnet sich 
jedoch, wenn wir beginnen, die Musik und die Kompositionen über den 
Code weitergehend zu strukturieren. In den nächsten Abschnitten 
schauen wir einige wirkungsvolle neue Werkzeuge dafür an. Als 
erstes kommen die Iteration und die Schleife (engl. *Loop*) dran.

## Wiederholung

Möchtest Du Code, den Du geschrieben hast, einige Male wiederholen? Zum 
Beispiel hast Du vielleicht ungefähr so etwas:

```
play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25
```

Was, wenn Du das drei Mal wiederholen wolltest? Naja, die Lösung ist
einfach! Du kannst den Code kopieren und drei Mal hintereinander 
einfügen:

```
play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25

play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25

play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25
```

Das ist natürlich eine Menge Code! Was wäre, wenn Du das Sample in 
`:elec_plip` umändern wolltest? Du müsstest alle Stellen mit 
`:elec_blub` finden und ändern. Und weiter: Was, wenn Du das 
ursprüngliche Codestück 50 oder 1000 Mal wiederholen wolltest? Das wäre 
noch mehr Code, und Du müsstest eine Menge Zeilen bearbeiten, wenn Du 
etwas ändern wolltest.

## Iteration

Wenn man Code wiederholt ablaufen lassen wollte, müsste man eigentlich 
nur sagen: *Mach das drei Mal*. Und so ist es auch in 
etwa. Erinnerst Du Dich an unseren Freund, den Code-Block? Wir können 
damit den Anfang und das Ende des Codes markieren, den wir drei Mal 
wiederholen wollen. Dann benutzen wir den speziellen Ausdruck 
`3.times`. Wir schreiben zwar nicht *mach das drei Mal*, wir schreiben 
`3.times do` - also nicht besonders schwierig. Denk aber daran, ans 
Ende des zu wiederholenden Code-Blocks gehört ein `end`.

```
3.times do
  play 50
  sleep 0.5
  sample :elec_blup
  sleep 0.5
  play 62
  sleep 0.25
end
```

Na, ist das nicht viel eleganter als kopieren und einfügen? Wir können 
das gut gebrauchen, um eine Menge sich wiederholender Strukturen zu 
erzeugen.

```
4.times do
  play 50
  sleep 0.5
end

8.times do
  play 55, release: 0.2
  sleep 0.25
end

4.times do
  play 50
  sleep 0.5
end
```

## Verschachtelte Iterationen

Wir können Iterationen in andere Iterationen hinein packen, um damit 
interessante Muster zu erzeugen. Zum Beispiel:

```
4.times do
  sample :drum_heavy_kick
  2.times do
    sample :elec_blip2, rate: 2
    sleep 0.25
  end
  sample :elec_snare
  4.times do
    sample :drum_tom_mid_soft
    sleep 0.125
  end
end
```

## Schleifen

Wenn Du etwas sehr oft wiederholen möchtest, könnte es sein, dass Du 
mit sehr hohen Zahlen arbeiten musst, wie zum Beispiel `1000.times do`. 
In einem solchen Fall macht es mehr Sinn, Sonic Pi dazu zu bringen, den 
Code in einer Endlos-Schleife zu wiederholen (zumindest, bis Du den
Stopp-Button klickst!). Wiederholen wir den Amen Break unendlich oft:

```
loop do
  sample :loop_amen
  sleep sample_duration :loop_amen
end
```

Eine wichtige Sache bei Endlos-Schleifen ist, dass sie für den Code wie 
schwarze Löcher sind. Wenn der Code einmal in einer Endlos-Schleife
läuft, kann er diese nicht mehr verlassen, bis Du auf Stopp klickst - 
ansonsten wird er für immer weiterlaufen. Das bedeutet, wenn hinter 
Deiner Endlos-Schleife noch weiterer Code steht, wirst Du diesen *nie*
hören. Zum Beispiel wird das Becken hinter dieser Schleife nie spielen:

```
loop do
  play 50
  sleep 1
end

sample :drum_cymbal_open
```

Jetzt fang an und strukturiere Deinen Code mit Wiederholungen und 
Schleifen!
