5.3 Bedingungen

# Bedingungen

Wahrscheinlich willst Du häufig nicht nur einen einen zufälligen Ton
abspielen (siehe das Kapitel über Zufallszahlen), sondern auch eine 
zufällige Entscheidung treffen: je nachdem wie diese ausfällt, möchtest 
Du dann den einen oder anderen Code ausführen. Zum Beispiel könnte es 
sein, dass Du zufällig entweder eine Trommel oder ein Becken anschlagen 
möchtest. Das können wir mit einem `if`-Ausdruck erreichen.

## Wirf eine Münze

Werfen wir also ein Münze: bei Kopf, spiele eine Trommel, bei Zahl, ein 
Becken. Das ist leicht. Wir können den Münzwurf mit unserer 
`one_in`-Funktion nachbilden (eingeführt im Kapitel über 
Randomisierung), indem wir eine Wahrscheinlichkeit von 1 aus 2 angeben: 
`one_in(2)`. Das Ergebnis dieser Berechnung benutzen wir, um zwischen 
zwei Codestücken auszuwählen, entweder den Code für die Trommel oder
für das Becken:

```
loop do

  if one_in(2)
    sample :drum_heavy_kick
  else
    sample :drum_cymbal_closed
  end
  
  sleep 0.5
  
end
```

Denke daran, dass `if`-Anweisungen drei Teile haben:

* die Frage, die gestellt wird,
* die erste Wahl des Codes, der ablaufen soll (wenn die Antwort auf die Frage ein Ja ist),
* die zweite Wahl des Codes, der ablaufen soll (wenn die Antwort auf die Frage ein Nein ist).

Für Programmiersprachen typisch steht für das Ja der Ausdruck `true` 
(wahr) und für das Nein der Ausdruck `false` (falsch). 
Also müssen wir eine Frage finden, die uns eine Antwort gibt, die 
entweder wahr oder falsch ist; genau das erledigt im Beispiel `one_in`.

Beachte, dass die erste Wahl zwischen `if` und `else` und die zweite 
Wahl zwischen `else` und `end` eingeschlossen wird. So wie bei den 
do/end-Blöcken kannst Du beliebig viele Codezeilen an beide Stellen 
schreiben. Zum Beispiel:

```
loop do

  if one_in(2)
    sample :drum_heavy_kick
    sleep 0.5
  else
    sample :drum_cymbal_closed
    sleep 0.25
  end
  
end
```

Dieses Mal schläft der Klang unterschiedlich lange, je nachdem, welche 
Auswahl getroffen wird.

## Einfaches if

Manchmal möchtest Du wahlweise nur eine Codezeile ausführen. Dafür
hängst Du ein `if` und die Frage an das Ende der Codezeile, zum
Beispiel:

```
use_synth :dsaw

loop do
  play 50, amp: 0.3, release: 2
  play 53, amp: 0.3, release: 2 if one_in(2)
  play 57, amp: 0.3, release: 2 if one_in(3)
  play 60, amp: 0.3, release: 2 if one_in(4)
  sleep 1.5
end
```

Dieses Beispiel setzt einen Akkord aus verschiedenen Noten
zusammen, wobei die Chance, dass bestimmte Noten gespielt 
werden, eine unterschiedliche Wahrscheinlichkeit hat.
