6.1 FX hinzufügen

# FX hinzufügen

In diesem Abschnitt sehen wir uns zwei Effekte genauer an: Hall 
und Echo. Wir werden lernen, wie diese Effekte zu benutzen sind,
wie man ihre Parameter steuern kann, und wie man sie verketten kann.

Das FX-System von Sonic Pi benutzt sogenannte Code-Blocks. Falls Du 
Abschnitt 5.1 des Tutorials noch nicht gelesen hast, sieh es Dir doch 
kurz an und kehre dann hierher zurück.

## Hall ('Reverb') 

Um den Hall-Effekt zu benutzen, fügen wir `with_fx :reverb` als 
Spezialcode zu unserem bestehenden Code-Block hinzu. Und zwar so:

```
with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Wenn Du nun diesen Code-Block abspielst, wirst Du hören, dass der 
Hall-Effekt hinzugefügt wurde. Hört sich gut an, nicht wahr! Mit 
Hall-Effekt hört sich alles immer ziemlich gut an.

Aber was passiert, wenn wir den Code außerhalb des do/end-Code-Blocks
hinzufügen:

```
with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end

sleep 1
play 55
```

Wie Du sicher bemerkt hast, wird nun die letzte Note (55) nicht mehr 
mit Hall-Effekt abgespielt. Der Grund dafür ist, dass sich die Note 
ausserhalb des do/end Code-Blocks befindet und deshalb unsere 
Anweisung zum Hall-Effekt für sie nicht mehr gültig ist.

Wenn Du Noten vor dem do/end-Code-Block einfügst, verhält es sich ganz 
ähnlich, und sie werden ebenfalls ohne Hall-Effekt abgespielt:

```
play 55
sleep 1

with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end

sleep 1
play 55
```

## Echo

Es stehen noch viele weitere Effekte zur Auswahl. Wie wäre es zum
Beispiel mit etwas Echo?

```
with_fx :echo do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Die FX-Blocks von Sonic Pi sind besonders vielfältig einsetzbar, denn
sie lassen sich über Parameter steuern. Genauso wie die Befehle `play`
und `sample`, die wir ja schon kennen. Ein spannender Echo-Parameter ist
zum  Beispiel `phase:`. Dieser Parameter stellt die Dauer des Echos in 
Schlägen dar. Versuchen wir, das Echo etwas langsamer zu machen:

```
with_fx :echo, phase: 0.5 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Und jetzt lass uns das Echo wieder schneller machen:

```
with_fx :echo, phase: 0.125 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Wie wäre es nun mit einem langsam ausschwingenden Echo? Wir 
können dafür einfach den `decay:`-Wert auf 8 Schläge verlängern:

```
with_fx :echo, phase: 0.5, decay: 8 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

## FX verschachteln

Interessant wird es, wenn wir die FX-Blocks ineinander verschachteln.
So können eine Vielzahl verschiedener FX leicht verkettet werden. Wie 
wäre es zum Beispiel damit, einen Code-Block zuerst mit Echo und dann 
mit Hall zu versehen? Das geht ganz einfach, Du musst nur die beiden 
Code-Blocks ineinander verschachteln:

```
with_fx :reverb do
  with_fx :echo, phase: 0.5, decay: 8 do
    play 50
    sleep 0.5
    sample :elec_blup
    sleep 0.5
    play 62
  end
end
```

Stell Dir das so vor, als ob die erzeugten Klänge von innen nach außen 
fließen würden. Der erzeugte Klang des innersten do/end-Code-Blocks 
(zum Beispiel 'play 50') wird zuerst durch den Echo-FX-Block gesendet, 
und danach noch durch den Hall-FX-Block.

Es ist ganz einfach, mit vielschichtigen Verschachtelungen verrückte 
Ergebnisse zu erzielen. Aber sei vorsichtig, weil FX viel Rechenkraft
des Computers verbraucht, besonders dann, wenn Du mehrere FX 
zugleich benutzt. Sei also etwas sparsam mit Deinen FX, wenn Du mit 
eher rechenschwachen Geräten wie dem Raspberry Pi arbeitest.

## Weitere FX entdecken

Sonic Pi bringt eine Vielzahl von FX mit, die Du ausprobieren 
kannst. Eine komplette Liste findest Du im Hilfe-Fenster, wenn Du
dort links auf 'FX' klickst. Hier sind einige meiner Favoriten:

* wobble
* reverb
* echo
* distortion
* slicer

Jetzt aber los, mach was Verrücktes und baue überall in Deinem Code FX 
ein. Du wirst unglaubliche neue Klänge erzeugen!
