/*
 * Copyright (C) 2009-2010  Lorenzo Bettini <http://www.lorenzobettini.it>
 * See COPYING file that comes with this distribution
 */

#include "statusbarframe.h"
#include "ui_statusbarframe.h"

StatusBarFrame::StatusBarFrame(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::StatusBarFrame)
{
    ui->setupUi(this);
}

StatusBarFrame::~StatusBarFrame()
{
    delete ui;
}

void StatusBarFrame::setLineCol(int line, int col) {
    ui->lineColLabel->setText(QString("Line: %1, Col: %2").arg(line).arg(col));
}

void StatusBarFrame::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
